ModCallbacks = {
	MC_NPC_UPDATE = 0,
	MC_POST_UPDATE = 1,
	MC_POST_RENDER = 2,
	MC_USE_ITEM = 3,
	MC_POST_PEFFECT_UPDATE = 4,
	MC_USE_CARD = 5,
	MC_FAMILIAR_UPDATE = 6,
	MC_FAMILIAR_INIT = 7,
	MC_EVALUATE_CACHE = 8,
	MC_POST_PLAYER_INIT = 9,
  MC_USE_PILL = 10,
  MC_ENTITY_TAKE_DMG = 11
}

EntityType = {
	ENTITY_NULL = 0,
	ENTITY_PLAYER = 1,     --  1 player
	ENTITY_TEAR = 2,       --  2 tear projectile
	ENTITY_FAMILIAR = 3,   --  3 familiar
	ENTITY_BOMBDROP = 4,   --  4 bomb drop
	ENTITY_PICKUP = 5,     --	 5 pickup item
	ENTITY_SLOT = 6,			 --  6 slot machine
	ENTITY_LASER = 7,      --  7 laser beam
	ENTITY_KNIFE = 8,      --  8 mom's knife
	ENTITY_PROJECTILE = 9, --	 9 blood projectile
	ENTITY_GAPER = 10,      -- 10 enemy: Gaper
	ENTITY_GUSHER = 11,     -- 11 enemy: Gusher
	ENTITY_HORF = 12,       -- 12 enemy: Horf
	ENTITY_FLY = 13,        -- 13 enemy: Fly
	ENTITY_POOTER = 14,     -- 14 enemy: Pooter
	ENTITY_CLOTTY = 15,     -- 15 enemy: Clotty
	ENTITY_MULLIGAN = 16,   -- 16 enemy: Mulligan
	ENTITY_SHOPKEEPER = 17,
	ENTITY_ATTACKFLY = 18,  -- 18 enemy: Attack Fly
	ENTITY_LARRYJR = 19,    -- 19 boss: Larry Jr./Hollow
	ENTITY_MONSTRO = 20,    -- 20 boss: Monstro
	ENTITY_MAGGOT = 21,
	ENTITY_HIVE = 22,
	ENTITY_CHARGER = 23,
	ENTITY_GLOBIN = 24,
	ENTITY_BOOMFLY = 25,
	ENTITY_MAW = 26,
	ENTITY_HOST = 27,
	ENTITY_CHUB = 28,
	ENTITY_HOPPER = 29,     -- 29 enemy: Hopper
	ENTITY_BOIL = 30,	-- 30 enemy: Boil, variants: 1 - Gut, 2 - Sack
	ENTITY_SPITY = 31,
	ENTITY_BRAIN = 32,
	ENTITY_FIREPLACE = 33,
	ENTITY_LEAPER = 34,
	ENTITY_MRMAW = 35,
	ENTITY_GURDY = 36,
	ENTITY_BABY = 38,
	ENTITY_VIS = 39,
	ENTITY_GUTS = 40,
	ENTITY_KNIGHT = 41,
	ENTITY_STONEHEAD = 42,
	ENTITY_MONSTRO2 = 43,
	ENTITY_POKY = 44,
	ENTITY_MOM = 45,
	ENTITY_SLOTH = 46, -- 46 miniboss: Sloth
	ENTITY_LUST = 47,  -- 47 miniboss: Lust
	ENTITY_WRATH = 48, -- 48 miniboss: Wrath
	ENTITY_GLUTTONY = 49, -- 49 miniboss: Gluttony
	ENTITY_GREED = 50, -- 50 miniboss: Greed
	ENTITY_ENVY = 51,  -- 51 miniboss: Envy
	ENTITY_PRIDE = 52, -- 52 miniboss: Pride
	ENTITY_DOPLE = 53,
	ENTITY_FLAMINGHOPPER = 54, -- 54 enemy: Flaming Hopper
	ENTITY_LEECH = 55,
	ENTITY_LUMP = 56,
	ENTITY_MEMBRAIN = 57, -- 57 enemy: Membrain and Mama Guts
	ENTITY_PARA_BITE = 58,
	ENTITY_FRED = 59,
	ENTITY_EYE = 60,
	ENTITY_SUCKER = 61, -- 61 enemy: Sucker
	ENTITY_PIN = 62,	 -- 62 boss: Pin
	ENTITY_FAMINE = 63,
	ENTITY_PESTILENCE = 64,
	ENTITY_WAR = 65, -- variant 1: Conquest
	ENTITY_DEATH = 66,
	ENTITY_DUKE = 67,	 -- 67 boss: Duke of Flies/Husk
	ENTITY_PEEP = 68,
	ENTITY_LOKI = 69,
	ENTITY_FISTULA_BIG = 71,
	ENTITY_FISTULA_MEDIUM = 72,
	ENTITY_FISTULA_SMALL = 73,
	ENTITY_BLASTOCYST_BIG = 74,	-- 74 boss: Blastocyst
	ENTITY_BLASTOCYST_MEDIUM = 75,
	ENTITY_BLASTOCYST_SMALL = 76,
	ENTITY_EMBRYO = 77,
	ENTITY_MOMS_HEART = 78,
	ENTITY_GEMINI = 79, -- 79 boss: Gemini
	ENTITY_MOTER = 80, -- 80 enemy: Moter
	ENTITY_FALLEN = 81, -- variant 1: Krampus
	ENTITY_HEADLESS_HORSEMAN = 82, -- Headless Horseman
	ENTITY_HORSEMAN_HEAD = 83, -- Head for Headless Horseman
	ENTITY_SATAN = 84,
	ENTITY_SPIDER = 85, -- 85 enemy: Spider
	ENTITY_KEEPER = 86,
	ENTITY_GURGLE = 87,
	ENTITY_WALKINGBOIL = 88, -- ai for WalkingBoil, WalkingGut and WalkingSack
	ENTITY_BUTTLICKER = 89,
	ENTITY_HANGER = 90, -- 90 enemy: Hanger
	ENTITY_SWARMER = 91,
	ENTITY_HEART = 92,
	ENTITY_MASK = 93,
	ENTITY_BIGSPIDER = 94,
	ENTITY_ETERNALFLY = 96, -- 96 enemy: Eternal Fly
	ENTITY_MASK_OF_INFAMY = 97,
	ENTITY_HEART_OF_INFAMY = 98,
	ENTITY_GURDY_JR = 99, -- 99 enemy: Gurdy Jr.
	ENTITY_WIDOW = 100,
	ENTITY_DADDYLONGLEGS = 101,
	ENTITY_ISAAC = 102,

    -- Rebirth enemies
	ENTITY_STONE_EYE = 201,
	ENTITY_CONSTANT_STONE_SHOOTER = 202,
	ENTITY_BRIMSTONE_HEAD = 203,
	ENTITY_MOBILE_HOST = 204,
	ENTITY_NEST = 205,
	ENTITY_BABY_LONG_LEGS = 206,
	ENTITY_CRAZY_LONG_LEGS = 207,
	ENTITY_FATTY = 208,
	ENTITY_FAT_SACK = 209,
	ENTITY_BLUBBER = 210,
	ENTITY_HALF_SACK = 211,
	ENTITY_DEATHS_HEAD = 212,
	ENTITY_MOMS_HAND = 213,
	ENTITY_FLY_L2 = 214,
	ENTITY_SPIDER_L2 = 215,
	ENTITY_SWINGER = 216,
	ENTITY_DIP = 217,
	ENTITY_WALL_HUGGER = 218,
	ENTITY_WIZOOB = 219,
	ENTITY_SQUIRT = 220,
	ENTITY_COD_WORM = 221,
	ENTITY_RING_OF_FLIES = 222,
	ENTITY_DINGA = 223,
	ENTITY_OOB = 224,
	ENTITY_BLACK_MAW = 225,
	ENTITY_SKINNY = 226,
	ENTITY_BONY = 227,
	ENTITY_HOMUNCULUS = 228,
	ENTITY_TUMOR = 229,
	ENTITY_CAMILLO_JR = 230,
	ENTITY_NERVE_ENDING = 231,
	ENTITY_SKINBALL = 232,
	ENTITY_MOM_HEAD = 233,
	ENTITY_ONE_TOOTH = 234,
	ENTITY_GAPING_MAW = 235,
	ENTITY_BROKEN_GAPING_MAW = 236,
	ENTITY_GURGLING = 237,
	ENTITY_SPLASHER = 238,
	ENTITY_GRUB = 239,
	ENTITY_WALL_CREEP = 240,
	ENTITY_RAGE_CREEP = 241,
	ENTITY_BLIND_CREEP = 242,
	ENTITY_CONJOINED_SPITTY = 243,
	ENTITY_ROUND_WORM = 244,
	ENTITY_POOP = 245,
	ENTITY_RAGLING = 246,
	ENTITY_FLESH_MOBILE_HOST = 247,
	ENTITY_PSY_HORF = 248,
	ENTITY_FULL_FLY = 249,
	ENTITY_TICKING_SPIDER = 250,
	ENTITY_BEGOTTEN = 251,
	ENTITY_NULLS = 252,
	ENTITY_PSY_TUMOR = 253,
	ENTITY_FLOATING_KNIGHT = 254,
	ENTITY_NIGHT_CRAWLER = 255,
	--Afterbirth
	ENTITY_DART_FLY = 256,
	ENTITY_CONJOINED_FATTY = 257,
	ENTITY_FAT_BAT = 258,
	ENTITY_IMP = 259,

	--Rebirth bosses
	ENTITY_THE_HAUNT = 260,
	ENTITY_DINGLE = 261,
	ENTITY_MEGA_MAW = 262,
	ENTITY_GATE = 263,
	ENTITY_MEGA_FATTY = 264,
	ENTITY_CAGE = 265,
	ENTITY_MAMA_GURDY = 266,
	ENTITY_DARK_ONE = 267,
	ENTITY_ADVERSARY = 268,
	ENTITY_POLYCEPHALUS = 269,
	ENTITY_MR_FRED = 270,
	ENTITY_URIEL = 271,
	ENTITY_GABRIEL = 272,
	ENTITY_THE_LAMB = 273,
	ENTITY_MEGA_SATAN = 274,
	ENTITY_MEGA_SATAN_2 = 275,

	--Afterbirth #2
	ENTITY_ROUNDY = 276,
	ENTITY_BLACK_BONY = 277,
	ENTITY_BLACK_GLOBIN = 278,
	ENTITY_BLACK_GLOBIN_HEAD = 279,
	ENTITY_BLACK_GLOBIN_BODY = 280,
	ENTITY_SWARM = 281,
	ENTITY_MEGA_CLOTTY = 282,
	ENTITY_BONE_KNIGHT = 283,
	ENTITY_CYCLOPIA = 284,
	ENTITY_RED_GHOST = 285,
	ENTITY_FLESH_DEATHS_HEAD = 286,
	ENTITY_MOMS_DEAD_HAND = 287,
	ENTITY_DUKIE = 288,
	ENTITY_ULCER = 289,
	ENTITY_MEATBALL = 290,
	ENTITY_PITFALL = 291,
	ENTITY_MOVABLE_TNT = 292,
	ENTITY_ULTRA_COIN = 293,
	ENTITY_ULTRA_DOOR = 294,
	ENTITY_CORN_MINE = 295,
	ENTITY_HUSH_FLY = 296,
	ENTITY_HUSH_GAPER = 297,
	ENTITY_HUSH_BOIL = 298,
	ENTITY_GREED_GAPER = 299,

	-- Afterbirth bosses
	ENTITY_STAIN = 401,
	ENTITY_BROWNIE = 402,
	ENTITY_FORSAKEN = 403,
	ENTITY_LITTLE_HORN = 404,
	ENTITY_RAG_MAN = 405,
	ENTITY_ULTRA_GREED = 406,
	ENTITY_HUSH = 407,
	ENTITY_HUSH_SKINLESS = 408,

	ENTITY_EFFECT = 1000, -- 1000 special effects
	ENTITY_TEXT = 9001
}

GridEntityType = {
	GRID_NULL = 0,
	GRID_DECORATION = 1,
	GRID_ROCK = 2,
	GRID_ROCKB = 3,	
	GRID_ROCKT = 4,	
	GRID_ROCK_BOMB = 5,	
	GRID_ROCK_ALT = 6,	
	GRID_PIT = 7,
	GRID_SPIKES = 8,
	GRID_SPIKES_ONOFF = 9,
	GRID_SPIDERWEB = 10,
	GRID_LOCK = 11,
	GRID_TNT = 12,
	GRID_FIREPLACE = 13, -- not used!
	GRID_POOP = 14,
	GRID_WALL = 15,
	GRID_DOOR = 16,
	GRID_TRAPDOOR = 17,
	GRID_STAIRS = 18,
	GRID_GRAVITY = 19,
	GRID_PRESSURE_PLATE = 20,
	GRID_STATUE = 21,
	GRID_ROCK_SS = 22
}

EffectVariant = {
	EFFECT_NULL = 0,
	BOMB_EXPLOSION = 1,
	BLOOD_EXPLOSION = 2,
	FLY_EXPLOSION = 3,
	ROCK_PARTICLE = 4,
	BLOOD_PARTICLE = 5,
	DEVIL = 6,
	BLOOD_SPLAT = 7,
	LADDER = 8,
	ANGEL = 9,
	BLUE_FLAME = 10,
	BULLET_POOF = 11,
	TEAR_POOF_A = 12,
	TEAR_POOF_B = 13,
	CROSS_POOF = 14,
	POOF01 = 15,
	POOF02 = 16,
	POOF04 = 17,
	BOMB_CRATER = 18,
	CRACK_THE_SKY = 19,
	SCYTHE_BREAK = 20,
	TINY_BUG = 21,
	CREEP_RED = 22,
	CREEP_GREEN = 23,
	CREEP_YELLOW = 24,
	CREEP_WHITE = 25,
	CREEP_BLACK = 26,
	WOOD_PARTICLE = 27,
	MONSTROS_TOOTH = 28,
	MOM_FOOT_STOMP = 29,
	TARGET = 30,
	ROCKET = 31,
	PLAYER_CREEP_LEMON_MISHAP = 32,
	TINY_FLY = 33,
	FART = 34,
	TOOTH_PARTICLE = 35,
	XRAY_WALL = 36,
	PLAYER_CREEP_HOLYWATER = 37,
	SPIDER_EXPLOSION = 38,
	HEAVEN_LIGHT_DOOR = 39,
	STARFLASH = 40,
	WATER_DROPLET = 41,
	BLOOD_GUSH = 42,
	POOP_EXPLOSION = 43,
	PLAYER_CREEP_WHITE = 44,
	PLAYER_CREEP_BLACK = 45,
	PLAYER_CREEP_RED = 46,
	TRINITY_SHIELD = 47,
	BATTERY = 48,
	HEART = 49,
	LASER_IMPACT = 50,
	HOT_BOMB_FIRE = 51,
	RED_CANDLE_FLAME = 52,
	PLAYER_CREEP_GREEN = 53,
	PLAYER_CREEP_HOLYWATER_TRAIL = 54,
	SPIKE = 55,			
	CREEP_BROWN = 56,	
	PULLING_EFFECT = 57,
	POOP_PARTICLE = 58,	
	DUST_CLOUD = 59,	
	BOOMERANG = 60,
	SHOCKWAVE = 61,
	ROCK_EXPLOSION = 62,
	WORM = 63, 
	BEETLE = 64,
	WISP = 65,
	EMBER_PARTICLE = 66, 
	SHOCKWAVE_DIRECTIONAL = 67,
	WALL_BUG = 68,
	BUTTERFLY = 69,
	BLOOD_DROP = 70,
	BRIMSTONE_SWIRL = 71,
	CRACKWAVE = 72,
	SHOCKWAVE_RANDOM = 73,
	ISAACS_CARPET = 74,
	BAR_PARTICLE = 75, 
	DICE_FLOOR = 76,
	LARGE_BLOOD_EXPLOSION = 77,
	PLAYER_CREEP_LEMON_PARTY = 78,
	TEAR_POOF_SMALL = 79,
	TEAR_POOF_VERYSMALL = 80,
	FRIEND_BALL = 81,
	WOMB_TELEPORT = 82,
	SPEAR_OF_DESTINY = 83,
	EVIL_EYE = 84,
	DIAMOND_PARTICLE = 85,
	NAIL_PARTICLE = 86,
	FALLING_EMBER = 87,
	DARK_BALL_SMOKE_PARTICLE = 88,
	ULTRA_GREED_FOOTPRINT = 89,
	PLAYER_CREEP_PUDDLE_MILK = 90,
	MOMS_HAND = 91,
	PLAYER_CREEP_BLACKPOWDER = 92,
	PENTAGRAM_BLACKPOWDER = 93,
	CREEP_SLIPPERY_BROWN = 94,
	GOLD_PARTICLE = 95,
	HUSH_LASER = 96,
	IMPACT = 97,
	COIN_PARTICLE = 98,
	WATER_SPLASH = 99,
	HUSH_ASHES = 100,
	HUSH_LASER_UP = 101,
	BULLET_POOF_HUSH = 102,
	ULTRA_GREED_BLING = 103,
	FIREWORKS = 104
}

PickupVariant = {
	PICKUP_NULL = 0,
	PICKUP_HEART = 10,
	PICKUP_COIN = 20,
	PICKUP_KEY = 30,
	PICKUP_BOMB = 40,
	PICKUP_CHEST = 50,
	PICKUP_BOMBCHEST = 51,
	PICKUP_SPIKEDCHEST = 52,
	PICKUP_ETERNALCHEST = 53,
	PICKUP_LOCKEDCHEST = 60,
	PICKUP_GRAB_BAG = 69,
	PICKUP_PILL = 70,
	PICKUP_LIL_BATTERY = 90,
	PICKUP_COLLECTIBLE = 100,
	PICKUP_SHOPITEM = 150,
	PICKUP_TAROTCARD = 300,
	PICKUP_BIGCHEST = 340,
	PICKUP_TRINKET = 350,
	PICKUP_REDCHEST = 360,
	PICKUP_TROPHY = 370,
	PICKUP_BED = 380
}

HeartSubType = {
	HEART_FULL = 1,
	HEART_HALF = 2,
	HEART_SOUL = 3,
	HEART_ETERNAL = 4,
	HEART_DOUBLEPACK = 5,
	HEART_BLACK = 6,
	HEART_GOLDEN = 7,
  HEART_HALF_SOUL = 8,
  HEART_SCARED = 9,
  HEART_BLENDED = 10
}

CoinSubType = {
	COIN_PENNY = 1,
	COIN_NICKEL = 2,
	COIN_DIME = 3,
	COIN_DOUBLEPACK = 4,
	COIN_LUCKYPENNY = 5,
	COIN_STICKYNICKEL = 6
}

KeySubType = {
	KEY_NORMAL = 1,
	KEY_GOLDEN = 2,
	KEY_DOUBLEPACK = 3,
  KEY_CHARGED = 4
}

ChestSubType = {
	CHEST_OPENED = 0,
	CHEST_CLOSED = 1
}
BombSubType = {
	BOMB_NORMAL = 1,
	BOMB_DOUBLEPACK = 2,
	BOMB_TROLL = 3,
	BOMB_GOLDEN = 4,
	BOMB_SUPERTROLL = 5
}

PickupPrice = {
	PRICE_ONE_HEART = -1,
	PRICE_TWO_HEARTS = -2,
	PRICE_THREE_SOULHEARTS = -3,
	PRICE_FREE = -1000
};

Challenge = {
	CHALLENGE_NULL = 0,
	CHALLENGE_PITCH_BLACK = 1,
	CHALLENGE_HIGH_BROW = 2,
	CHALLENGE_HEAD_TRAUMA = 3,
	CHALLENGE_DARKNESS_FALLS = 4,
	CHALLENGE_THE_TANK = 5,
	CHALLENGE_SOLAR_SYSTEM = 6,
	CHALLENGE_SUICIDE_KING = 7,
	CHALLENGE_CAT_GOT_YOUR_TONGUE = 8,
	CHALLENGE_DEMO_MAN = 9,
	CHALLENGE_CURSED = 10,
	CHALLENGE_GLASS_CANNON = 11,
	CHALLENGE_WHEN_LIFE_GIVES_LEMONS = 12,
	CHALLENGE_BEANS = 13,
	CHALLENGE_ITS_IN_THE_CARDS = 14,
	CHALLENGE_SLOW_ROLL = 15,
	CHALLENGE_COMPUTER_SAVY = 16,
	CHALLENGE_WAKA_WAKA = 17,
	CHALLENGE_THE_HOST = 18,
	CHALLENGE_THE_FAMILY_MAN = 19,
	CHALLENGE_PURIST = 20,
	CHALLENGE_XXXXXXXXL = 21,
	CHALLENGE_SPEED = 22,
	CHALLENGE_BLUE_BOMBER = 23,
	CHALLENGE_PAY_TO_PLAY = 24,
	CHALLENGE_HAVE_A_HEART = 25,
	CHALLENGE_I_RULE = 26,
	CHALLENGE_BRAINS = 27,
	CHALLENGE_PRIDE_DAY = 28,
	CHALLENGE_ONANS_STREAK = 29,
	CHALLENGE_GUARDIAN = 30,
	CHALLENGE_BACKASSWARDS = 31,
	CHALLENGE_APRILS_FOOL = 32,
	CHALLENGE_POKEY_MANS = 33,
	CHALLENGE_ULTRA_HARD = 34,
	CHALLENGE_PONG = 35,
	NUM_CHALLENGES = 36
}
BombVariant = {
    BOMB_NORMAL = 0,
    BOMB_BIG = 1,
    BOMB_DECOY = 2,
    BOMB_TROLL = 3,
    BOMB_SUPERTROLL = 4,
    BOMB_POISON = 5,
    BOMB_POISON_BIG = 6,
    BOMB_SAD = 7,
    BOMB_HOT = 8,
    BOMB_BUTT = 9,
    BOMB_MR_MEGA = 10,
    BOMB_BOBBY = 11,
    BOMB_GLITTER = 12
}

CacheFlag = {
		CACHE_DAMAGE = 1,
		CACHE_FIREDELAY = 2,
		CACHE_SHOTSPEED = 4,
		CACHE_RANGE = 8,
		CACHE_SPEED = 16,
		CACHE_TEARFLAG = 32,
		CACHE_TEARCOLOR = 64,
		CACHE_FLYING = 128,
		CACHE_WEAPON = 256,
		CACHE_FAMILIARS = 512,
		CACHE_LUCK = 1024,
		CACHE_ALL = 0xFFFFFFFF
}

NpcState = {
		STATE_INIT = 0,
		STATE_APPEAR = 1,
		STATE_APPEAR_CUSTOM = 2, 
		STATE_IDLE = 3,
		STATE_MOVE = 4,
		STATE_SUICIDE = 5,
		STATE_JUMP = 6,
		STATE_STOMP = 7,
		STATE_ATTACK = 8,
		STATE_ATTACK2 = 9,	
		STATE_ATTACK3 = 10,
		STATE_ATTACK4 = 11,
		STATE_SUMMON = 12,	
		STATE_SUMMON2 = 13,
		STATE_SUMMON3 = 14,
		STATE_SPECIAL = 15,
		STATE_UNIQUE_DEATH = 16,
		STATE_DEATH = 17
}

EntityGridCollisionClass = {
  GRIDCOLL_NONE = 0,
  GRIDCOLL_WALLS_X = 1,	-- only collide with vertical walls
  GRIDCOLL_WALLS_Y = 2,	-- only collide with horizontal walls
  GRIDCOLL_WALLS = 3,		-- only collide with walls
  GRIDCOLL_BULLET = 4,	-- detect collision with solids (no pits), don't correct position
  GRIDCOLL_GROUND = 5,	-- collide with all grid entities (rocks, pits, ..), correct position
  GRIDCOLL_NOPITS = 6		-- collide with all grid entities except pits and correct position
}
	
EntityCollisionClass = {
  ENTCOLL_NONE = 0,			-- no collision with other entities
  ENTCOLL_PLAYERONLY = 1,		-- collide with player only
  ENTCOLL_PLAYEROBJECTS = 2,	-- collide with player, tears, familiars, ..
  ENTCOLL_ENEMIES = 3,		-- collide with enemies
  ENTCOLL_ALL = 4				-- collide with everything
}

EntityFlag = {
	FLAG_NO_STATUS_EFFECTS = 1,			-- prevent freeze/poison/slow/charm/confusion/fear/burn
	FLAG_NO_INTERPOLATE = 1<<1,			-- do not interpolate position
	FLAG_APPEAR = 1<<2,					-- play appear animation after Init
	FLAG_RENDER_FLOOR = 1<<3,				-- will be rendered to floor texture
	FLAG_NO_TARGET = 1<<4,					-- will not be a target of NPCs or familiars
	FLAG_FREEZE = 1<<5,					-- freezing effect
	FLAG_POISON = 1<<6,					-- poison effect
	FLAG_SLOW = 1<<7,						-- slowing (velocity)
	FLAG_CHARM = 1<<8,						-- Charmed
	FLAG_CONFUSION = 1<<9,					-- Confused
	FLAG_MIDAS_FREEZE = 1<<10,				-- Midas frozen
	FLAG_FEAR = 1<<11,						-- Fleeing in Fear (like Mom's Pad)
	FLAG_BURN = 1<<12,						-- Caused by Fire Mind tears, works like poison except with Red color effect.
	FLAG_RENDER_WALL = 1<<13,				-- will be rendered to wall texture
	FLAG_INTERPOLATION_UPDATE = 1<<14,		-- entity is updating at 60 fps, and this is an odd frame
	FLAG_APPLY_GRAVITY = 1<<15,			-- In sidescrolling room, this indicates that we're in a gravity zone.
	FLAG_NO_BLOOD_SPLASH = 1<<16,
	FLAG_NO_REMOVE_ON_TEX_RENDER = 1<<17,	-- for FLAG_RENDER_FLOOR and FLAG_RENDER_WALL
	FLAG_NO_DEATH_TRIGGER = 1<<18,
	FLAG_NO_SPIKE_DAMAGE = 1<<19,
	FLAG_BOSSDEATH_TRIGGERED = 1<<20,
	FLAG_DONT_OVERWRITE = 1<<21,			-- Used in entityfactory to not remove this entity if there is no space left for new entity
	FLAG_SPAWN_STICKY_SPIDERS = 1<<22,		-- Used by Sticky bombs to generate spiders on death
	FLAG_SPAWN_BLACK_HP = 1<<23,			-- Used by black hp drop tear flag to drop a black hp on enemy death
	FLAG_SHRINK = 1<<24,					-- God's flesh effect
	FLAG_NO_FLASH_ON_DAMAGE = 1<<25,		-- Entity will not flash red when damaged
	FLAG_NO_KNOCKBACK = 1<<26,				-- Bombs and farts have no knockback effects
	FLAG_SLIPPERY_PHYSICS = 1<<27,			-- Standing on a slippery surface
	FLAG_ADD_JAR_FLY = 1<<28,				-- Adds a fly to the jar when killed
	FLAG_FRIENDLY = 1<<29,					-- Charmed and m_CharmCountdown<0
	FLAG_NO_PHYSICS_KNOCKBACK = 1<<30,		-- No knockback from general collisions
	FLAG_DONT_COUNT_BOSS_HP = 1<<31,		-- Do not count boss hp
	FLAG_NO_SPRITE_UPDATE = 1<<32,			-- Do not update sprite animation
	FLAG_CONTAGIOUS = 1<<33,				-- Used for Contagious item (if the enemy is infected)
	FLAG_BLEED_OUT = 1<<34				-- Used for Mom's Razor
	--[[
		[Warning]
		Be careful with FLAG_DONT_OVERWRITE. Do not set it for all entities while 
		they all exist otherwise it may result in an undefined behaviour.
	--]]
}

DamageFlag = {
  DAMAGE_NOKILL = 1,			-- damage can not kill the receiver
  DAMAGE_FIRE = 1<<1,			-- source is some sort of fire (ie. fireplace)
  DAMAGE_EXPLOSION = 1<<2,	-- damage comes from an explosion
  DAMAGE_LASER = 1<<3,		-- damage comes from laser
  DAMAGE_ACID = 1<<4,			-- damage comes from acid, e.g. blood acid
  DAMAGE_RED_HEARTS = 1<<5,	-- damage affects only red hearts if > 1 (ex: razor)
  DAMAGE_COUNTDOWN = 1<<6,	-- damage from unicorn horn, the nail, game kid that has cooldown
  DAMAGE_SPIKES = 1<<7,		-- damage from spikes
  DAMAGE_CLONES = 1<<8,		-- damage is done by clones when they took damage, avoid infinite loops
  DAMAGE_POOP = 1<<9,			-- damage from red poop
  DAMAGE_DEVIL = 1<<10,		-- damage comes from devil room deal
  DAMAGE_ISSAC_HEART = 1<<11,	-- Indicates the damage has been redirected from Isaac's Heart familiar
  DAMAGE_TNT = 1<<12,			-- damage comes from a TNT barrel
  DAMAGE_INVINCIBLE = 1<<13,	-- damages even if invincible (currently only for player). Used on IV Bag.
  DAMAGE_SPAWN_FLY = 1<<14,	-- creates a fly when damage is applied
  DAMAGE_POISON_BURN = 1<<15, -- damage comes from POISON/BURN flags
  DAMAGE_CURSED_DOOR = 1<<16, -- damage comes from a cursed door
  DAMAGE_TIMER = 1<<17,		-- damage comes from the passage of time (used for player damage by time limited special seeds)
  DAMAGE_IV_BAG = 1<<18,		-- damage from using the IV Bag
  DAMAGE_PITFALL = 1<<19,		-- damage comes from the passage of time (used for player damage by time limited special seeds)
  DAMAGE_CHEST = 1<<20,		-- damage comes from spiked chest
  DAMAGE_FAKE = 1<<21		-- fake damage that should trigger player's damage effects.
}
	
SortingLayer = {
  SORTING_BACKGROUND = 0,			-- Background level, behind grid entities (creep, pitfalls)
  SORTING_DOOR = 1,				-- Used by door Xray animation
  SORTING_NORMAL = 2				-- Uses Y position to determine Z sorting
}
FamiliarVariant = {
	FAMILIAR_NULL = 0,
	BROTHER_BOBBY = 1,
	DEMON_BABY = 2,
	LITTLE_CHUBBY = 3,
	LITTLE_GISH = 4,
	LITTLE_STEVEN = 5,
	ROBO_BABY = 6,
	SISTER_MAGGY = 7,
	ABEL = 8,
	GHOST_BABY = 9,
	HARLEQUIN_BABY = 10,
	RAINBOW_BABY = 11,
	ISAACS_HEAD = 12,
	BLUE_BABY_SOUL = 13,
	DEAD_BIRD = 14,
	EVES_BIRD_FOOT = 15,
	DADDY_LONGLEGS = 16,
	PEEPER = 17,
	BOMB_BAG = 20,
	SACK_OF_PENNIES = 21,
	LITTLE_CHAD = 22,
	RELIC = 23,
	BUM_FRIEND = 24,
	HOLY_WATER = 25,
	KEY_PIECE_1 = 26,
	KEY_PIECE_2 = 27,
	KEY_FULL = 28,
	FOREVER_ALONE = 30,
	DISTANT_ADMIRATION = 31,
	GUARDIAN_ANGEL = 32,
	FLY_ORBITAL = 33,
	SACRIFICIAL_DAGGER = 35,
	DEAD_CAT = 40,
	ONE_UP = 41,
	GUPPYS_HAIRBALL = 42,
	BLUE_FLY = 43,
	CUBE_OF_MEAT_1 = 44,
	CUBE_OF_MEAT_2 = 45,
	CUBE_OF_MEAT_3 = 46,
	CUBE_OF_MEAT_4 = 47,
	ISAACS_BODY = 48,
	SMART_FLY = 50,
	DRY_BABY = 51,
	JUICY_SACK = 52,
	ROBO_BABY_2 = 53,
	ROTTEN_BABY = 54,
	HEADLESS_BABY = 55,
	LEECH = 56,
	MYSTERY_SACK = 57,
	BBF = 58,
	BOBS_BRAIN = 59,
	BEST_BUD = 60,
	LIL_BRIMSTONE = 61,
	ISAACS_HEART = 62,
	LIL_HAUNT = 63,
	DARK_BUM = 64,
	BIG_FAN = 65,
	SISSY_LONGLEGS = 66,
	PUNCHING_BAG = 67,
	GUILLOTINE = 68,
	BALL_OF_BANDAGES_1 = 69,
	BALL_OF_BANDAGES_2 = 70,
	BALL_OF_BANDAGES_3 = 71,
	BALL_OF_BANDAGES_4 = 72,
	BLUE_SPIDER = 73,
	MONGO_BABY = 74,
	SAMSONS_CHAINS = 75,
	CAINS_OTHER_EYE = 76,
	BLUEBABYS_ONLY_FRIEND = 77,
	SCISSORS = 78,
	GEMINI = 79,
	INCUBUS = 80,
	FATES_REWARD = 81,
	LIL_CHEST = 82,
	SWORN_PROTECTOR = 83,
	FRIEND_ZONE = 84,
	LOST_FLY = 85,
	CHARGED_BABY = 86,
	LIL_GURDY = 87,
	BUMBO = 88,
	CENSER = 89,
	KEY_BUM = 90,
	RUNE_BAG = 91,
	SERAPHIM = 92,
	GB_BUG = 93,
	SPIDER_MOD = 94,
	FARTING_BABY = 95,
	SUCCUBUS = 96,
	LIL_LOKI = 97,
	OBSESSED_FAN = 98,
	PAPA_FLY = 99,
	MILK = 100,
	MULTIDIMENSIONAL_BABY = 101,
	SUPER_BUM = 102,
	TONSIL = 103,
	BIG_CHUBBY = 104,
	DEPRESSION = 105,
	SHADE = 106,
	HUSHY = 107,
	LIL_MONSTRO = 108,
	KING_BABY = 109,
	FINGER = 110,
	YO_LISTEN = 111,
	ACID_BABY = 112,
	SPIDER_BABY = 113,
	SACK_OF_SACKS = 114,
	BROWN_NUGGET_POOTER = 115,
	BLOODSHOT_EYE = 116,
	MOMS_RAZOR = 117
}
LocustSubtypes = {
	LOCUST_OF_WRATH = 1,
	LOCUST_OF_PESTILENCE = 2,
	LOCUST_OF_FAMINE = 3,
	LOCUST_OF_DEATH = 4,
	LOCUST_OF_CONQUEST = 5
}
ItemType = {
	ITEM_NULL = 0,
	ITEM_PASSIVE = 1,
	ITEM_TRINKET = 2,
	ITEM_ACTIVE = 3,
	ITEM_FAMILIAR = 4
}
NullItemID = {
	ID_NULL = - 1,
	ID_EXPLOSIVE_DIARRHEA = 0,
	ID_PUBERTY = 1,
	ID_I_FOUND_PILLS = 2,
	ID_LORD_OF_THE_FLIES = 3,
	ID_STATUE = 4,
	ID_GUPPY = 5,
	ID_WIZARD = 6,
	ID_MAGDALENE = 7,
	ID_CAIN = 8,
	ID_JUDAS = 9,
	ID_EVE = 10,
	ID_AZAZEL = 11,
	ID_EDEN = 12,
	ID_SAMSON = 13,
	ID_BLINDFOLD = 14,
	ID_BLANKFACE = 15,
	ID_CHRISTMAS = 16,
	ID_PURITY_GLOW = 17,
	ID_EMPTY_VESSEL = 18,
	ID_MAW_MARK = 19,
	ID_MUSHROOM = 20,
	ID_ANGEL = 21,
	ID_BOB = 22,
	ID_DRUGS = 23,
	ID_MOM = 24,
	ID_BABY = 25,
	ID_EVIL_ANGEL = 26,
	ID_POOP = 27,
	ID_RELAX = 28,
	ID_OVERDOSE = 29,
	ID_BOOMERANG = 30,
	ID_MEGABLAST = 31,
	ID_LAZARUS = 32,
	ID_LAZARUS2 = 33,
	ID_LILITH = 34,
	ID_IWATA = 35,
	ID_APOLLYON = 36,
	ID_BOOKWORM = 37,
	ID_ADULTHOOD = 38,
	ID_SPIDERBABY = 39,
	NUM_NULLITEMS = 40
}
WeaponType = {
	WEAPON_TEARS = 1,
	WEAPON_BRIMSTONE = 2,
	WEAPON_LASER = 3,
	WEAPON_KNIFE = 4,
	WEAPON_BOMBS = 5,
	WEAPON_ROCKETS = 6,
	WEAPON_MONSTROS_LUNGS = 7,
	WEAPON_LUDOVICO_TECHNIQUE = 8,
	WEAPON_TECH_X = 9,
	NUM_WEAPON_TYPES = 10
}

PlayerItemState = {
	ITEMSTATE_NORMAL = 0,
	ITEMSTATE_CANDLE = 1,
	ITEMSTATE_SHOOP_DA_WHOOP = 2,
	ITEMSTATE_BOBS_ROTTEN_HEAD = 3,
	ITEMSTATE_DOCTORS_REMOTE = 4,
	ITEMSTATE_PONY = 5,
	ITEMSTATE_NOTCHEDAXE = 6,
	ITEMSTATE_BOOMERANG = 7,
	ITEMSTATE_CANNON = 8,
	ITEMSTATE_FRIENDBALL = 9
}
PlayerSpriteLayer = {
	SPRITE_GLOW = 0,
	SPRITE_BODY = 1,
	SPRITE_BODY0 = 2,
	SPRITE_BODY1 = 3,
	SPRITE_HEAD = 4,
	SPRITE_HEAD0 = 5,
	SPRITE_HEAD1 = 6,
	SPRITE_HEAD2 = 7,
	SPRITE_HEAD3 = 8,
	SPRITE_HEAD4 = 9,
	SPRITE_HEAD5 = 10,
	SPRITE_TOP0 = 11,
	SPRITE_EXTRA = 12,
	NUM_SPRITE_LAYERS = 13
}
BabySubType = {
	BABY_UNASSIGNED = - 1,
	BABY_SPIDER = 0,
	BABY_LOVE = 1,
	BABY_BLOAT = 2,
	BABY_WATER = 3,
	BABY_PSY = 4,
	BABY_CURSED = 5,
	BABY_TROLL = 6,
	BABY_YBAB = 7,
	BABY_COCKEYED = 8,
	BABY_HOST = 9,
	BABY_LOST = 10,
	BABY_CUTE = 11,
	BABY_CROW = 12,
	BABY_SHADOW = 13,
	BABY_GLASS = 14,
	BABY_GOLD = 15,
	BABY_CY = 16,
	BABY_BEAN = 17,
	BABY_MAG = 18,
	BABY_WRATH = 19,
	BABY_WRAPPED = 20,
	BABY_BEGOTTEN = 21,
	BABY_DEAD = 22,
	BABY_FIGHTING = 23,
	BABY_0 = 24,
	BABY_GLITCH = 25,
	BABY_MAGNET = 26,
	BABY_BLACK = 27,
	BABY_RED = 28,
	BABY_WHITE = 29,
	BABY_BLUE = 30,
	BABY_RAGE = 31,
	BABY_CRY = 32,
	BABY_YELLOW = 33,
	BABY_LONG = 34,
	BABY_GREEN = 35,
	BABY_LIL = 36,
	BABY_BIG = 37,
	BABY_BROWN = 38,
	BABY_NOOSE = 39,
	BABY_HIVE = 40,
	BABY_BUDDY = 41,
	BABY_COLORFUL = 42,
	BABY_WHORE = 43,
	BABY_CRACKED = 44,
	BABY_DRIPPING = 45,
	BABY_BLINDING = 46,
	BABY_SUCKY = 47,
	BABY_DARK = 48,
	BABY_PICKY = 49,
	BABY_REVENGE = 50,
	BABY_BELIAL = 51,
	BABY_SALE = 52,
	BABY_GOAT = 53,
	BABY_SUPER_GREED = 54,
	BABY_MORT = 55,
	BABY_APOLLYON = 56,
	BABY_BASIC = 57
}
LaserOffset = {
	LASER_TECH1_OFFSET = 0,
	LASER_TECH2_OFFSET = 1,
	LASER_TECH5_OFFSET = 2,
	LASER_SHOOP_OFFSET = 3,
	LASER_BRIMSTONE_OFFSET = 4,
	LASER_MOMS_EYE_OFFSET = 5,
	LASER_TRACTOR_BEAM_OFFSET = 6
}
ActionTriggers = {
	ACTIONTRIGGER_NONE = 0,
	ACTIONTRIGGER_BOMBPLACED = 1,
	ACTIONTRIGGER_MOVED = 1 << 1,
	ACTIONTRIGGER_SHOOTING = 1 << 2,
	ACTIONTRIGGER_CARDPILLUSED = 1 << 3,
	ACTIONTRIGGER_ITEMACTIVATED = 1 << 4,
	ACTIONTRIGGER_ITEMSDROPPED = 1 << 5
}
GridCollisionClass = {
	COLLISION_NONE = 0,
	COLLISION_PIT = 1,
	COLLISION_OBJECT = 2,
	COLLISION_SOLID = 3,
	COLLISION_WALL = 4,
	COLLISION_WALL_EXCEPT_PLAYER = 5
}


Direction = {
	NO_DIRECTION = -1,
  LEFT = 0,
  UP = 1,
  RIGHT = 2,
  DOWN = 3
}

LevelStage = {
	STAGE_NULL = 0,
	STAGE1_1 = 1,
	STAGE1_2 = 2,
	STAGE2_1 = 3,
	STAGE2_2 = 4,
	STAGE3_1 = 5,
	STAGE3_2 = 6,
	STAGE4_1 = 7,
	STAGE4_2 = 8,
	STAGE4_3 = 9,
	STAGE5 = 10,
	STAGE6 = 11,
	STAGE7 = 12,
	NUM_STAGES = 13,
	STAGE1_GREED = 1,
	STAGE2_GREED = 2,
	STAGE3_GREED = 3,
	STAGE4_GREED = 4,
	STAGE5_GREED = 5,
	STAGE6_GREED = 6,
	STAGE7_GREED = 7
}
StageType = {
	STAGETYPE_ORIGINAL = 0,
	STAGETYPE_WOTL = 1,
	STAGETYPE_AFTERBIRTH = 2,
	STAGETYPE_GREEDMODE = 3
}
RoomType = {
	ROOM_NULL = 0,
	ROOM_DEFAULT = 1,
	ROOM_SHOP = 2,
	ROOM_ERROR = 3,
	ROOM_TREASURE = 4,
	ROOM_BOSS = 5,
	ROOM_MINIBOSS = 6,
	ROOM_SECRET = 7,
	ROOM_SUPERSECRET = 8,
	ROOM_ARCADE = 9,
	ROOM_CURSE = 10,
	ROOM_CHALLENGE = 11,
	ROOM_LIBRARY = 12,
	ROOM_SACRIFICE = 13,
	ROOM_DEVIL = 14,
	ROOM_ANGEL = 15,
	ROOM_DUNGEON = 16,
	ROOM_BOSSRUSH = 17,
	ROOM_ISAACS = 18,
	ROOM_BARREN = 19,
	ROOM_CHEST = 20,
	ROOM_DICE = 21,
	ROOM_BLACK_MARKET = 22,
	ROOM_GREED_EXIT = 23,
	NUM_ROOMTYPES = 24
}
RoomShape = {
	ROOMSHAPE_1x1 = 1,
	ROOMSHAPE_IH = 2,
	ROOMSHAPE_IV = 3,
	ROOMSHAPE_1x2 = 4,
	ROOMSHAPE_IIV = 5,
	ROOMSHAPE_2x1 = 6,
	ROOMSHAPE_IIH = 7,
	ROOMSHAPE_2x2 = 8,
	ROOMSHAPE_LTL = 9,
	ROOMSHAPE_LTR = 10,
	ROOMSHAPE_LBL = 11,
	ROOMSHAPE_LBR = 12,
	NUM_ROOMSHAPES = 13
}
DoorSlot = {
	NO_DOOR_SLOT = - 1,
	LEFT0 = 0,
	UP0 = 1,
	RIGHT0 = 2,
	DOWN0 = 3,
	LEFT1 = 4,
	UP1 = 5,
	RIGHT1 = 6,
	DOWN1 = 7,
	NUM_DOOR_SLOTS = 8
}
LevelCurse = {
	CURSE_NONE = 0,
	CURSE_OF_DARKNESS = 1,
	CURSE_OF_LABYRINTH = 1 << 1,
	CURSE_OF_THE_LOST = 1 << 2,
	CURSE_OF_THE_UNKNOWN = 1 << 3,
	CURSE_OF_THE_CURSED = 1 << 4,
	CURSE_OF_MAZE = 1 << 5,
	CURSE_OF_BLIND = 1 << 6,
	NUM_CURSES = 8
}

PlayerType = {
	PLAYER_ISAAC = 0,
	PLAYER_MAGDALENA = 1,
	PLAYER_CAIN = 2,
	PLAYER_JUDAS = 3,
	PLAYER_XXX = 4,
	PLAYER_EVE = 5,
	PLAYER_SAMSON = 6,
	PLAYER_AZAZEL = 7,
	PLAYER_LAZARUS = 8,
	PLAYER_EDEN = 9,
	PLAYER_THELOST = 10,
	PLAYER_LAZARUS2 = 11,
	PLAYER_BLACKJUDAS = 12,
	PLAYER_LILITH = 13,
	PLAYER_KEEPER = 14,
	PLAYER_APOLLYON = 15,
	NUM_PLAYER_TYPES = 16
}
PlayerForm = {
	PLAYERFORM_GUPPY = 0,
	PLAYERFORM_LORD_OF_THE_FLIES = 1,
	PLAYERFORM_MUSHROOM = 2,
	PLAYERFORM_ANGEL = 3,
	PLAYERFORM_BOB = 4,
	PLAYERFORM_DRUGS = 5,
	PLAYERFORM_MOM = 6,
	PLAYERFORM_BABY = 7,
	PLAYERFORM_EVIL_ANGEL = 8,
	PLAYERFORM_POOP = 9,
	PLAYERFORM_BOOK_WORM = 10,
	PLAYERFORM_ADULTHOOD = 11,
	PLAYERFORM_SPIDERBABY = 12,
	NUM_PLAYER_FORMS = 13
}

PillColor = {
	PILL_NULL = 0,
	PILL_BLUE_BLUE = 1,
	PILL_WHITE_BLUE = 2,
	PILL_ORANGE_ORANGE = 3,
	PILL_WHITE_WHITE = 4,
	PILL_REDDOTS_RED = 5,
	PILL_PINK_RED = 6,
	PILL_BLUE_CADETBLUE = 7,
	PILL_YELLOW_ORANGE = 8,
	PILL_ORANGEDOTS_WHITE = 9,
	PILL_WHITE_AZURE = 10,
	PILL_BLACK_YELLOW = 11,
	PILL_WHITE_BLACK = 12,
	PILL_WHITE_YELLOW = 13,
	NUM_PILLS = 14
}
Music = {
	MUSIC_NULL = 0,
	MUSIC_BASEMENT = 1,
	MUSIC_CAVES = 2,
	MUSIC_DEPTHS = 3,
	MUSIC_CELLAR = 4,
	MUSIC_CATACOMBS = 5,
	MUSIC_NECROPOLIS = 6,
	MUSIC_WOMB_UTERO = 7,
	MUSIC_GAME_OVER = 8,
	MUSIC_BOSS = 9,
	MUSIC_CATHEDRAL = 10,
	MUSIC_SHEOL = 11,
	MUSIC_DARK_ROOM = 12,
	MUSIC_CHEST = 13,
	MUSIC_BURNING_BASEMENT = 14,
	MUSIC_FLOODED_CAVES = 15,
	MUSIC_DANK_DEPTHS = 16,
	MUSIC_SCARRED_WOMB = 17,
	MUSIC_BLUE_WOMB = 18,
	MUSIC_MOM_BOSS = 20,
	MUSIC_MOMS_HEART_BOSS = 21,
	MUSIC_ISAAC_BOSS = 22,
	MUSIC_SATAN_BOSS = 23,
	MUSIC_DARKROOM_BOSS = 24,
	MUSIC_BLUEBABY_BOSS = 25,
	MUSIC_BOSS2 = 26,
	MUSIC_HUSH_BOSS = 27,
	MUSIC_ULTRAGREED_BOSS = 28,
	MUSIC_LIBRARY_ROOM = 30,
	MUSIC_SECRET_ROOM = 31,
	MUSIC_DEVIL_ROOM = 33,
	MUSIC_ANGEL_ROOM = 34,
	MUSIC_SHOP_ROOM = 35,
	MUSIC_ARCADE_ROOM = 36,
	MUSIC_BOSS_OVER = 37,
	MUSIC_CHALLENGE_FIGHT = 38,
	MUSIC_CREDITS = 60,
	MUSIC_TITLE = 61,
	MUSIC_TITLE_AFTERBIRTH = 62,
	MUSIC_JINGLE_BOSS = 81,
	MUSIC_JINGLE_BOSS_OVER = 83,
	MUSIC_JINGLE_HOLYROOM_FIND = 84,
	MUSIC_JINGLE_SECRETROOM_FIND = 85,
	MUSIC_JINGLE_TREASUREROOM_ENTRY_0 = 87,
	MUSIC_JINGLE_TREASUREROOM_ENTRY_1 = 88,
	MUSIC_JINGLE_TREASUREROOM_ENTRY_2 = 89,
	MUSIC_JINGLE_TREASUREROOM_ENTRY_3 = 90,
	MUSIC_JINGLE_CHALLENGE_ENTRY = 91,
	MUSIC_JINGLE_CHALLENGE_OUTRO = 92,
	MUSIC_JINGLE_GAME_OVER = 93,
	MUSIC_JINGLE_DEVILROOM_FIND = 94,
	MUSIC_JINGLE_GAME_START = 95,
	MUSIC_JINGLE_NIGHTMARE = 96,
	MUSIC_JINGLE_BOSS_OVER2 = 97,
	MUSIC_JINGLE_HUSH_OVER = 98,
	MUSIC_INTRO_VOICEOVER = 100,
	MUSIC_EPILOGUE_VOICEOVER = 101,
	MUSIC_VOID = 102,
	MUSIC_VOID_BOSS = 103,
	NUM_MUSIC = 104
}
SoundEffect = {
	SOUND_NULL = 0,
	SOUND_1UP = 1,
	SOUND_BIRD_FLAP = 2,
	SOUND_BLOBBY_WIGGLE = 3,
	SOUND_INSECT_SWARM_LOOP = 4,
	SOUND_BLOOD_LASER = 5,
	SOUND_BLOOD_LASER_LARGE = 7,
	SOUND_BOOK_PAGE_TURN_12 = 8,
	SOUND_BOSS_BUG_HISS = 9,
	SOUND_BOSS_GURGLE_ROAR = 11,
	SOUND_BOSS_LITE_GURGLE = 12,
	SOUND_BOSS_LITE_HISS = 13,
	SOUND_BOSS_LITE_ROAR = 14,
	SOUND_BOSS_LITE_SLOPPY_ROAR = 15,
	SOUND_BOSS_SPIT_BLOB_BARF = 16,
	SOUND_CHEST_DROP = 21,
	SOUND_CHEST_OPEN = 22,
	SOUND_CHOIR_UNLOCK = 23,
	SOUND_COIN_SLOT = 24,
	SOUND_CUTE_GRUNT = 25,
	SOUND_DEATH_BURST_LARGE = 28,
	SOUND_DEATH_BURST_SMALL = 30,
	SOUND_DEATH_CARD = 33,
	SOUND_DEVIL_CARD = 34,
	SOUND_DOOR_HEAVY_CLOSE = 35,
	SOUND_DOOR_HEAVY_OPEN = 36,
	SOUND_FART = 37,
	SOUND_FETUS_JUMP = 38,
	SOUND_FETUS_LAND = 40,
	SOUND_FIREDEATH_HISS = 43,
	SOUND_FLOATY_BABY_ROAR = 44,
	SOUND_FORESTBOSS_STOMPS = 48,
	SOUND_GASCAN_POUR = 51,
	SOUND_HELLBOSS_GROUNDPOUND = 52,
	SOUND_HOLY = 54,
	SOUND_ISAAC_HURT_GRUNT = 55,
	SOUND_CHILD_HAPPY_ROAR_SHORT = 56,
	SOUND_CHILD_ANGRY_ROAR = 57,
	SOUND_KEYPICKUP_GAUNTLET = 58,
	SOUND_KEY_DROP0 = 59,
	SOUND_BABY_HURT = 60,
	SOUND_MAGGOT_BURST_OUT = 64,
	SOUND_MAGGOT_ENTER_GROUND = 66,
	SOUND_MEAT_FEET_SLOW0 = 68,
	SOUND_MEAT_IMPACTS = 69,
	SOUND_MEAT_JUMPS = 72,
	SOUND_MEATY_DEATHS = 77,
	SOUND_MOM_VOX_DEATH = 82,
	SOUND_MOM_VOX_EVILLAUGH = 84,
	SOUND_MOM_VOX_FILTERED_DEATH_1 = 85,
	SOUND_MOM_VOX_FILTERED_EVILLAUGH = 86,
	SOUND_MOM_VOX_FILTERED_HURT = 87,
	SOUND_MOM_VOX_FILTERED_ISAAC = 90,
	SOUND_MOM_VOX_GRUNT = 93,
	SOUND_MOM_VOX_HURT = 97,
	SOUND_MOM_VOX_ISAAC = 101,
	SOUND_MONSTER_GRUNT_0 = 104,
	SOUND_MONSTER_GRUNT_1 = 106,
	SOUND_MONSTER_GRUNT_2 = 108,
	SOUND_MONSTER_GRUNT_4 = 112,
	SOUND_MONSTER_GRUNT_5 = 114,
	SOUND_MONSTER_ROAR_0 = 115,
	SOUND_MONSTER_ROAR_1 = 116,
	SOUND_MONSTER_ROAR_2 = 117,
	SOUND_MONSTER_ROAR_3 = 118,
	SOUND_MONSTER_YELL_A = 119,
	SOUND_MONSTER_YELL_B = 122,
	SOUND_POWERUP1 = 128,
	SOUND_POWERUP2 = 129,
	SOUND_POWERUP3 = 130,
	SOUND_POWERUP_SPEWER = 132,
	SOUND_REDLIGHTNING_ZAP = 133,
	SOUND_ROCK_CRUMBLE = 137,
	SOUND_POT_BREAK = 138,
	SOUND_MUSHROOM_POOF = 139,
	SOUND_ROCKET_BLAST_DEATH = 141,
	SOUND_SMB_LARGE_CHEWS_4 = 142,
	SOUND_SCARED_WHIMPER = 143,
	SOUND_SHAKEY_KID_ROAR = 146,
	SOUND_SINK_DRAIN_GURGLE = 149,
	SOUND_TEARIMPACTS = 150,
	SOUND_TEARS_FIRE = 153,
	SOUND_UNLOCK00 = 156,
	SOUND_VAMP_GULP = 157,
	SOUND_WHEEZY_COUGH = 158,
	SOUND_SPIDER_COUGH = 159,
	SOUND_ZOMBIE_WALKER_KID = 165,
	SOUND_ANIMAL_SQUISH = 166,
	SOUND_ANGRY_GURGLE = 167,
	SOUND_BAND_AID_PICK_UP = 169,
	SOUND_BATTERYCHARGE = 170,
	SOUND_BEEP = 171,
	SOUND_BLOODBANK_SPAWN = 175,
	SOUND_BLOODSHOOT = 178,
	SOUND_BOIL_HATCH = 181,
	SOUND_BOSS1_EXPLOSIONS = 182,
	SOUND_BOSS2_BUBBLES = 185,
	SOUND_BOSS2INTRO_ERRORBUZZ = 187,
	SOUND_CASTLEPORTCULLIS = 190,
	SOUND_CHARACTER_SELECT_LEFT = 194,
	SOUND_CHARACTER_SELECT_RIGHT = 195,
	SOUND_DERP = 197,
	SOUND_DIMEDROP = 198,
	SOUND_DIMEPICKUP = 199,
	SOUND_FETUS_FEET = 201,
	SOUND_GOLDENKEY = 204,
	SOUND_GOOATTACH0 = 205,
	SOUND_GOODEATH = 207,
	SOUND_HAND_LASERS = 211,
	SOUND_HEARTIN = 212,
	SOUND_HEARTOUT = 213,
	SOUND_HELL_PORTAL1 = 214,
	SOUND_HELL_PORTAL2 = 215,
	SOUND_ISAACDIES = 217,
	SOUND_ITEMRECHARGE = 218,
	SOUND_KISS_LIPS1 = 219,
	SOUND_LEECH = 221,
	SOUND_MAGGOTCHARGE = 224,
	SOUND_MEATHEADSHOOT = 226,
	SOUND_METAL_BLOCKBREAK = 229,
	SOUND_NICKELDROP = 231,
	SOUND_NICKELPICKUP = 232,
	SOUND_PENNYDROP = 233,
	SOUND_PENNYPICKUP = 234,
	SOUND_PLOP = 237,
	SOUND_SATAN_APPEAR = 238,
	SOUND_SATAN_BLAST = 239,
	SOUND_SATAN_CHARGE_UP = 240,
	SOUND_SATAN_GROW = 241,
	SOUND_SATAN_HURT = 242,
	SOUND_SATAN_RISE_UP = 243,
	SOUND_SATAN_SPIT = 245,
	SOUND_SATAN_STOMP = 246,
	SOUND_SCAMPER = 249,
	SOUND_SHELLGAME = 252,
	SOUND_SLOTSPAWN = 255,
	SOUND_SPLATTER = 258,
	SOUND_STEAM_HALFSEC = 261,
	SOUND_STONESHOOT = 262,
	SOUND_WEIRD_WORM_SPIT = 263,
	SOUND_SUMMONSOUND = 265,
	SOUND_SUPERHOLY = 266,
	SOUND_THUMBS_DOWN = 267,
	SOUND_THUMBSUP = 268,
	SOUND_FIRE_BURN = 269,
	SOUND_HAPPY_RAINBOW = 270,
	SOUND_BOO_MAD = 300,
	SOUND_FART_GURG = 301,
	SOUND_FAT_GRUNT = 302,
	SOUND_FAT_WIGGLE = 303,
	SOUND_FIRE_RUSH = 304,
	SOUND_GHOST_ROAR = 305,
	SOUND_GHOST_SHOOT = 306,
	SOUND_GRROOWL = 307,
	SOUND_GURG_BARF = 308,
	SOUND_INHALE = 309,
	SOUND_LOW_INHALE = 310,
	SOUND_MEGA_PUKE = 311,
	SOUND_MOUTH_FULL = 312,
	SOUND_MULTI_SCREAM = 313,
	SOUND_SKIN_PULL = 314,
	SOUND_WHISTLE = 315,
	SOUND_DEVILROOM_DEAL = 316,
	SOUND_SPIDER_SPIT_ROAR = 317,
	SOUND_WORM_SPIT = 318,
	SOUND_LITTLE_SPIT = 319,
	SOUND_SATAN_ROOM_APPEAR = 320,
	SOUND_HEARTBEAT = 321,
	SOUND_HEARTBEAT_FASTER = 322,
	SOUND_HEARTBEAT_FASTEST = 323,
	SOUND_48_HR_ENERGY = 324,
	SOUND_ALGIZ = 325,
	SOUND_AMNESIA = 326,
	SOUND_ANZUS = 327,
	SOUND_BAD_GAS = 328,
	SOUND_BAD_TRIP = 329,
	SOUND_BALLS_OF_STEEL = 330,
	SOUND_BERKANO = 331,
	SOUND_BOMBS_ARE_KEY = 332,
	SOUND_CARD_VS_HUMAN = 333,
	SOUND_CHAOS_CARD = 334,
	SOUND_CREDIT_CARD = 335,
	SOUND_DAGAZ = 336,
	SOUND_DEATH = 337,
	SOUND_EHWAZ = 338,
	SOUND_EXPLOSIVE_DIAH = 339,
	SOUND_FULL_HP = 340,
	SOUND_HAGALAZ = 341,
	SOUND_HP_DOWN = 342,
	SOUND_HP_UP = 343,
	SOUND_HEMATEMISIS = 344,
	SOUND_I_FOUND_PILLS = 345,
	SOUND_JERA = 346,
	SOUND_JOKER = 347,
	SOUND_JUDGEMENT = 348,
	SOUND_JUSTICE = 349,
	SOUND_LEMON_PARTY = 350,
	SOUND_LUCK_DOWN = 351,
	SOUND_LUCK_UP = 352,
	SOUND_PARALYSIS = 353,
	SOUND_PERTHRO = 354,
	SOUND_PHEROMONES = 355,
	SOUND_PRETTY_FLY = 356,
	SOUND_PUBERTY = 357,
	SOUND_RUA_WIZ = 358,
	SOUND_RANGE_DOWN = 359,
	SOUND_RANGE_UP = 360,
	SOUND_RULES_CARD = 361,
	SOUND_SEE_4EVER = 362,
	SOUND_SPEED_DOWN = 363,
	SOUND_SPEED_UP = 364,
	SOUND_STRENGTH = 365,
	SOUND_SUICIDE_KING = 366,
	SOUND_TEARS_DOWN = 367,
	SOUND_TEARS_UP = 368,
	SOUND_TELEPILLS = 369,
	SOUND_TEMPERANCE = 370,
	SOUND_THE_CHARIOT = 371,
	SOUND_THE_DEVIL = 372,
	SOUND_THE_EMPEROR = 373,
	SOUND_EMPRESS = 374,
	SOUND_FOOL = 375,
	SOUND_HANGED_MAN = 376,
	SOUND_HERMIT = 377,
	SOUND_HIEROPHANT = 378,
	SOUND_HIGHT_PRIESTESS = 379,
	SOUND_THE_LOVERS = 380,
	SOUND_MAGICIAN = 381,
	SOUND_MOON = 382,
	SOUND_STARS = 383,
	SOUND_SUN = 384,
	SOUND_TOWER = 385,
	SOUND_WORLD = 386,
	SOUND_TWO_CLUBS = 387,
	SOUND_TWO_DIAMONDS = 388,
	SOUND_TWO_HEARTS = 389,
	SOUND_TWO_SPADES = 390,
	SOUND_WHEEL_OF_FORTUNE = 391,
	SOUND_RAGMAN_1 = 392,
	SOUND_RAGMAN_2 = 393,
	SOUND_RAGMAN_3 = 394,
	SOUND_RAGMAN_4 = 395,
	SOUND_FLUSH = 396,
	SOUND_WATER_DROP = 397,
	SOUND_WET_FEET = 398,
	SOUND_ADDICTED = 399,
	SOUND_DICE_SHARD = 400,
	SOUND_EMERGENCY = 401,
	SOUND_INFESTED_EXCL = 402,
	SOUND_INFESTED_QUEST = 403,
	SOUND_JAIL_CARD = 404,
	SOUND_LARGER = 405,
	SOUND_PERCS = 406,
	SOUND_POWER_PILL = 407,
	SOUND_QUESTION_MARK = 408,
	SOUND_RELAX = 409,
	SOUND_RETRO = 410,
	SOUND_SMALL = 411,
	SOUND_QQQ = 412,
	SOUND_DANGLE_WHISTLE = 413,
	SOUND_LITTLE_HORN_COUGH = 414,
	SOUND_LITTLE_HORN_GRUNT_1 = 415,
	SOUND_LITTLE_HORN_GRUNT_2 = 416,
	SOUND_THE_FORSAKEN_LAUGH = 417,
	SOUND_THE_FORSAKEN_SCREAM = 418,
	SOUND_THE_STAIN_BURST = 419,
	SOUND_BROWNIE_LAUGH = 420,
	SOUND_HUSH_ROAR = 421,
	SOUND_HUSH_GROWL = 422,
	SOUND_HUSH_LOW_ROAR = 423,
	SOUND_FRAIL_CHARGE = 424,
	SOUND_HUSH_CHARGE = 425,
	SOUND_MAW_OF_VOID = 426,
	SOUND_ULTRA_GREED_COIN_DESTROY = 427,
	SOUND_ULTRA_GREED_COINS_FALLING = 428,
	SOUND_ULTRA_GREED_DEATH_SCREAM = 429,
	SOUND_ULTRA_GREED_TURN_GOLD_1 = 430,
	SOUND_ULTRA_GREED_TURN_GOLD_2 = 431,
	SOUND_ULTRA_GREED_ROAR_1 = 432,
	SOUND_ULTRA_GREED_ROAR_2 = 433,
	SOUND_ULTRA_GREED_SPIT = 434,
	SOUND_ULTRA_GREED_PULL_SLOT = 435,
	SOUND_ULTRA_GREED_SLOT_SPIN_LOOP = 436,
	SOUND_ULTRA_GREED_SLOT_STOP = 437,
	SOUND_ULTRA_GREED_SLOT_WIN_LOOP_END = 438,
	SOUND_ULTRA_GREED_SLOT_WIN_LOOP = 439,
	SOUND_ULTRA_GREED_SPINNING = 440,
	SOUND_DOG_BARK = 441,
	SOUND_DOG_HOWELL = 442,
	SOUND_X_LAX = 443,
	SOUND_WRONG = 444,
	SOUND_VURP = 445,
	SOUND_SUNSHINE = 446,
	SOUND_SPADES = 447,
	SOUND_HORF = 448,
	SOUND_HOLY_CARD = 449,
	SOUND_HEARTS = 450,
	SOUND_GULP = 451,
	SOUND_FRIENDS = 452,
	SOUND_EXCITED = 453,
	SOUND_DROWSY = 454,
	SOUND_DIAMONDS = 455,
	SOUND_CLUBS = 456,
	SOUND_BLACK_RUNE = 457,
	NUM_SOUND_EFFECTS = 458
}
DoorState = {
	STATE_INIT = 0,
	STATE_CLOSED = 1,
	STATE_OPEN = 2,
	STATE_ONE_CHAIN = 3,
	STATE_HALF_CRACKED = 4
}
DoorVariant = {
	DOOR_UNSPECIFIED = 0,
	DOOR_LOCKED = 1,
	DOOR_LOCKED_DOUBLE = 2,
	DOOR_LOCKED_CRACKED = 3,
	DOOR_LOCKED_BARRED = 4,
	DOOR_LOCKED_KEYFAMILIAR = 5,
	DOOR_LOCKED_GREED = 6,
	DOOR_HIDDEN = 7,
	DOOR_UNLOCKED = 8
}
Difficulty = {
	DIFFICULTY_NORMAL = 0,
	DIFFICULTY_HARD = 1,
	DIFFICULTY_GREED = 2,
	DIFFICULTY_GREEDIER = 3
}
LevelStateFlag = {
	STATE_BUM_KILLED = 0,
	STATE_EVIL_BUM_KILLED = 1,
	STATE_REDHEART_DAMAGED = 2,
	STATE_BUM_LEFT = 3,
	STATE_EVIL_BUM_LEFT = 4,
	STATE_DAMAGED = 5,
	STATE_SHOPKEEPER_KILLED_LVL = 6,
	STATE_COMPASS_EFFECT = 7,
	STATE_MAP_EFFECT = 8,
	STATE_BLUE_MAP_EFFECT = 9,
	STATE_FULL_MAP_EFFECT = 10,
	STATE_GREED_LOST_PENALTY = 11,
	STATE_GREED_MONSTRO_SPAWNED = 12,
	STATE_ITEM_DUNGEON_FOUND = 13,
	STATE_MAMA_MEGA_USED = 14,
	NUM_STATE_FLAGS = 15
}
GameStateFlag = {
	STATE_FAMINE_SPAWNED = 0,
	STATE_PESTILENCE_SPAWNED = 1,
	STATE_WAR_SPAWNED = 2,
	STATE_DEATH_SPAWNED = 3,
	STATE_BOSSPOOL_SWITCHED = 4,
	STATE_DEVILROOM_SPAWNED = 5,
	STATE_DEVILROOM_VISITED = 6,
	STATE_BOOK_REVELATIONS_USED = 7,
	STATE_BOOK_PICKED_UP = 8,
	STATE_WRATH_SPAWNED = 9,
	STATE_GLUTTONY_SPAWNED = 10,
	STATE_LUST_SPAWNED = 11,
	STATE_SLOTH_SPAWNED = 12,
	STATE_ENVY_SPAWNED = 13,
	STATE_PRIDE_SPAWNED = 14,
	STATE_GREED_SPAWNED = 15,
	STATE_SUPERGREED_SPAWNED = 16,
	STATE_DONATION_SLOT_BROKEN = 17,
	STATE_DONATION_SLOT_JAMMED = 18,
	STATE_HEAVEN_PATH = 19,
	STATE_REBIRTH_BOSS_SWITCHED = 20,
	STATE_HAUNT_SELECTED = 21,
	STATE_ADVERSARY_SELECTED = 22,
	STATE_MR_FRED_SELECTED = 23,
	STATE_MAMA_GURDY_SELECTED = 24,
	STATE_URIEL_SPAWNED = 25,
	STATE_GABRIEL_SPAWNED = 26,
	STATE_FALLEN_SPAWNED = 27,
	STATE_HEADLESS_HORSEMAN_SPAWNED = 28,
	STATE_KRAMPUS_SPAWNED = 29,
	STATE_DONATION_SLOT_BLOWN = 30,
	STATE_SHOPKEEPER_KILLED = 31,
	STATE_ULTRAPRIDE_SPAWNED = 32,
	STATE_BOSSRUSH_DONE = 33,
	STATE_GREED_SLOT_JAMMED = 34,
	STATE_AFTERBIRTH_BOSS_SWITCHED = 35,
	STATE_BROWNIE_SELECTED = 36,
	STATE_SUPERBUM_APPEARED = 37,
	STATE_BOSSRUSH_DOOR_SPAWNED = 38,
	STATE_BLUEWOMB_DOOR_SPAWNED = 39,
	STATE_BLUEWOMB_DONE = 40,
	STATE_HEART_BOMB_COIN_PICKED = 41,
	STATE_ABPLUS_BOSS_SWITCHED = 42,
	STATE_SISTERS_VIS_SELECTED = 43,
	NUM_STATE_FLAGS = 44
}
CollectibleType = {
	COLLECTIBLE_NULL = 0,
	COLLECTIBLE_SAD_ONION = 1,
	COLLECTIBLE_INNER_EYE = 2,
	COLLECTIBLE_SPOON_BENDER = 3,
	COLLECTIBLE_MAXS_HEAD = 4,
	COLLECTIBLE_MY_REFLECTION = 5,
	COLLECTIBLE_NUMBER_ONE = 6,
	COLLECTIBLE_BLOOD_MARTYR = 7,
	COLLECTIBLE_BROTHER_BOBBY = 8,
	COLLECTIBLE_SKATOLE = 9,
	COLLECTIBLE_HALO_OF_FLIES = 10,
	COLLECTIBLE_ONE_UP = 11,
	COLLECTIBLE_MAGIC_MUSHROOM = 12,
	COLLECTIBLE_VIRUS = 13,
	COLLECTIBLE_ROID_RAGE = 14,
	COLLECTIBLE_HEART = 15,
	COLLECTIBLE_RAW_LIVER = 16,
	COLLECTIBLE_SKELETON_KEY = 17,
	COLLECTIBLE_DOLLAR = 18,
	COLLECTIBLE_BOOM = 19,
	COLLECTIBLE_TRANSCENDENCE = 20,
	COLLECTIBLE_COMPASS = 21,
	COLLECTIBLE_LUNCH = 22,
	COLLECTIBLE_DINNER = 23,
	COLLECTIBLE_DESSERT = 24,
	COLLECTIBLE_BREAKFAST = 25,
	COLLECTIBLE_ROTTEN_MEAT = 26,
	COLLECTIBLE_WOODEN_SPOON = 27,
	COLLECTIBLE_BELT = 28,
	COLLECTIBLE_MOMS_UNDERWEAR = 29,
	COLLECTIBLE_MOMS_HEELS = 30,
	COLLECTIBLE_MOMS_LIPSTICK = 31,
	COLLECTIBLE_WIRE_COAT_HANGER = 32,
	COLLECTIBLE_BIBLE = 33,
	COLLECTIBLE_BOOK_OF_BELIAL = 34,
	COLLECTIBLE_NECRONOMICON = 35,
	COLLECTIBLE_POOP = 36,
	COLLECTIBLE_MR_BOOM = 37,
	COLLECTIBLE_TAMMYS_HEAD = 38,
	COLLECTIBLE_MOMS_BRA = 39,
	COLLECTIBLE_KAMIKAZE = 40,
	COLLECTIBLE_MOMS_PAD = 41,
	COLLECTIBLE_BOBS_ROTTEN_HEAD = 42,
	COLLECTIBLE_PILLS_HERE = 43,
	COLLECTIBLE_TELEPORT = 44,
	COLLECTIBLE_YUM_HEART = 45,
	COLLECTIBLE_LUCKY_FOOT = 46,
	COLLECTIBLE_DOCTORS_REMOTE = 47,
	COLLECTIBLE_CUPIDS_ARROW = 48,
	COLLECTIBLE_SHOOP_DA_WHOOP = 49,
	COLLECTIBLE_STEVEN = 50,
	COLLECTIBLE_PENTAGRAM = 51,
	COLLECTIBLE_DR_FETUS = 52,
	COLLECTIBLE_MAGNETO = 53,
	COLLECTIBLE_TREASURE_MAP = 54,
	COLLECTIBLE_MOMS_EYE = 55,
	COLLECTIBLE_LEMON_MISHAP = 56,
	COLLECTIBLE_DISTANT_ADMIRATION = 57,
	COLLECTIBLE_BOOK_OF_SHADOWS = 58,
	COLLECTIBLE_059 = 59,
	COLLECTIBLE_LADDER = 60,
	COLLECTIBLE_TAROT_CARD = 61,
	COLLECTIBLE_CHARM_VAMPIRE = 62,
	COLLECTIBLE_BATTERY = 63,
	COLLECTIBLE_STEAM_SALE = 64,
	COLLECTIBLE_ANARCHIST_COOKBOOK = 65,
	COLLECTIBLE_HOURGLASS = 66,
	COLLECTIBLE_SISTER_MAGGY = 67,
	COLLECTIBLE_TECHNOLOGY = 68,
	COLLECTIBLE_CHOCOLATE_MILK = 69,
	COLLECTIBLE_GROWTH_HORMONES = 70,
	COLLECTIBLE_MINI_MUSH = 71,
	COLLECTIBLE_ROSARY = 72,
	COLLECTIBLE_CUBE_OF_MEAT = 73,
	COLLECTIBLE_QUARTER = 74,
	COLLECTIBLE_PHD = 75,
	COLLECTIBLE_XRAY_VISION = 76,
	COLLECTIBLE_MY_LITTLE_UNICORN = 77,
	COLLECTIBLE_BOOK_REVELATIONS = 78,
	COLLECTIBLE_MARK = 79,
	COLLECTIBLE_PACT = 80,
	COLLECTIBLE_DEAD_CAT = 81,
	COLLECTIBLE_LORD_OF_THE_PIT = 82,
	COLLECTIBLE_THE_NAIL = 83,
	COLLECTIBLE_WE_NEED_GO_DEEPER = 84,
	COLLECTIBLE_DECK_OF_CARDS = 85,
	COLLECTIBLE_MONSTROS_TOOTH = 86,
	COLLECTIBLE_LOKIS_HORNS = 87,
	COLLECTIBLE_LITTLE_CHUBBY = 88,
	COLLECTIBLE_SPIDER_BITE = 89,
	COLLECTIBLE_SMALL_ROCK = 90,
	COLLECTIBLE_SPELUNKER_HAT = 91,
	COLLECTIBLE_SUPER_BANDAGE = 92,
	COLLECTIBLE_GAMEKID = 93,
	COLLECTIBLE_SACK_OF_PENNIES = 94,
	COLLECTIBLE_ROBO_BABY = 95,
	COLLECTIBLE_LITTLE_CHAD = 96,
	COLLECTIBLE_BOOK_OF_SIN = 97,
	COLLECTIBLE_RELIC = 98,
	COLLECTIBLE_LITTLE_GISH = 99,
	COLLECTIBLE_LITTLE_STEVEN = 100,
	COLLECTIBLE_HALO = 101,
	COLLECTIBLE_MOMS_BOTTLE_PILLS = 102,
	COLLECTIBLE_COMMON_COLD = 103,
	COLLECTIBLE_PARASITE = 104,
	COLLECTIBLE_D6 = 105,
	COLLECTIBLE_MR_MEGA = 106,
	COLLECTIBLE_PINKING_SHEARS = 107,
	COLLECTIBLE_WAFER = 108,
	COLLECTIBLE_MONEY_IS_POWER = 109,
	COLLECTIBLE_MOMS_CONTACTS = 110,
	COLLECTIBLE_BEAN = 111,
	COLLECTIBLE_GUARDIAN_ANGEL = 112,
	COLLECTIBLE_DEMON_BABY = 113,
	COLLECTIBLE_MOMS_KNIFE = 114,
	COLLECTIBLE_OUIJA_BOARD = 115,
	COLLECTIBLE_NINE_VOLT = 116,
	COLLECTIBLE_DEAD_BIRD = 117,
	COLLECTIBLE_BRIMSTONE = 118,
	COLLECTIBLE_BLOOD_BAG = 119,
	COLLECTIBLE_ODD_MUSHROOM_RATE = 120,
	COLLECTIBLE_ODD_MUSHROOM_DAMAGE = 121,
	COLLECTIBLE_WHORE_OF_BABYLON = 122,
	COLLECTIBLE_MONSTER_MANUAL = 123,
	COLLECTIBLE_DEAD_SEA_SCROLLS = 124,
	COLLECTIBLE_BOBBY_BOMB = 125,
	COLLECTIBLE_RAZOR_BLADE = 126,
	COLLECTIBLE_FORGET_ME_NOW = 127,
	COLLECTIBLE_FOREVER_ALONE = 128,
	COLLECTIBLE_BUCKET_LARD = 129,
	COLLECTIBLE_PONY = 130,
	COLLECTIBLE_BOMB_BAG = 131,
	COLLECTIBLE_LUMP_OF_COAL = 132,
	COLLECTIBLE_GUPPYS_PAW = 133,
	COLLECTIBLE_GUPPYS_TAIL = 134,
	COLLECTIBLE_IV_BAG = 135,
	COLLECTIBLE_BEST_FRIEND = 136,
	COLLECTIBLE_REMOTE_DETONATOR = 137,
	COLLECTIBLE_STIGMATA = 138,
	COLLECTIBLE_MOMS_PURSE = 139,
	COLLECTIBLE_BOBS_CURSE = 140,
	COLLECTIBLE_PAGEANT_BOY = 141,
	COLLECTIBLE_SCAPULAR = 142,
	COLLECTIBLE_SPEED_BALL = 143,
	COLLECTIBLE_BUM_FRIEND = 144,
	COLLECTIBLE_GUPPYS_HEAD = 145,
	COLLECTIBLE_PRAYER_CARD = 146,
	COLLECTIBLE_NOTCHED_AXE = 147,
	COLLECTIBLE_INFESTATION = 148,
	COLLECTIBLE_IPECAC = 149,
	COLLECTIBLE_TOUGH_LOVE = 150,
	COLLECTIBLE_MULLIGAN = 151,
	COLLECTIBLE_TECHNOLOGY_2 = 152,
	COLLECTIBLE_MUTANT_SPIDER = 153,
	COLLECTIBLE_CHEMICAL_PEEL = 154,
	COLLECTIBLE_PEEPER = 155,
	COLLECTIBLE_HABIT = 156,
	COLLECTIBLE_BLOODY_LUST = 157,
	COLLECTIBLE_CRYSTAL_BALL = 158,
	COLLECTIBLE_SPIRIT_NIGHT = 159,
	COLLECTIBLE_CRACK_THE_SKY = 160,
	COLLECTIBLE_ANKH = 161,
	COLLECTIBLE_CELTIC_CROSS = 162,
	COLLECTIBLE_GHOST_BABY = 163,
	COLLECTIBLE_CANDLE = 164,
	COLLECTIBLE_CAT_NINE_TAILS = 165,
	COLLECTIBLE_D20 = 166,
	COLLECTIBLE_HARLEQUIN_BABY = 167,
	COLLECTIBLE_EPIC_FETUS = 168,
	COLLECTIBLE_POLYPHEMUS = 169,
	COLLECTIBLE_DADDY_LONGLEGS = 170,
	COLLECTIBLE_SPIDER_BUTT = 171,
	COLLECTIBLE_SACRIFICIAL_DAGGER = 172,
	COLLECTIBLE_MITRE = 173,
	COLLECTIBLE_RAINBOW_BABY = 174,
	COLLECTIBLE_DADS_KEY = 175,
	COLLECTIBLE_STEM_CELLS = 176,
	COLLECTIBLE_PORTABLE_SLOT = 177,
	COLLECTIBLE_HOLY_WATER = 178,
	COLLECTIBLE_FATE = 179,
	COLLECTIBLE_BLACK_BEAN = 180,
	COLLECTIBLE_WHITE_PONY = 181,
	COLLECTIBLE_SACRED_HEART = 182,
	COLLECTIBLE_TOOTH_PICKS = 183,
	COLLECTIBLE_HOLY_GRAIL = 184,
	COLLECTIBLE_DEAD_DOVE = 185,
	COLLECTIBLE_BLOOD_RIGHTS = 186,
	COLLECTIBLE_GUPPYS_HAIRBALL = 187,
	COLLECTIBLE_ABEL = 188,
	COLLECTIBLE_SMB_SUPER_FAN = 189,
	COLLECTIBLE_PYRO = 190,
	COLLECTIBLE_3_DOLLAR_BILL = 191,
	COLLECTIBLE_TELEPATHY_BOOK = 192,
	COLLECTIBLE_MEAT = 193,
	COLLECTIBLE_MAGIC_8_BALL = 194,
	COLLECTIBLE_MOMS_COIN_PURSE = 195,
	COLLECTIBLE_SQUEEZY = 196,
	COLLECTIBLE_JESUS_JUICE = 197,
	COLLECTIBLE_BOX = 198,
	COLLECTIBLE_MOMS_KEY = 199,
	COLLECTIBLE_MOMS_EYESHADOW = 200,
	COLLECTIBLE_IRON_BAR = 201,
	COLLECTIBLE_MIDAS_TOUCH = 202,
	COLLECTIBLE_HUMBLEING_BUNDLE = 203,
	COLLECTIBLE_FANNY_PACK = 204,
	COLLECTIBLE_SHARP_PLUG = 205,
	COLLECTIBLE_GUILLOTINE = 206,
	COLLECTIBLE_BALL_OF_BANDAGES = 207,
	COLLECTIBLE_CHAMPION_BELT = 208,
	COLLECTIBLE_BUTT_BOMBS = 209,
	COLLECTIBLE_GNAWED_LEAF = 210,
	COLLECTIBLE_SPIDERBABY = 211,
	COLLECTIBLE_GUPPYS_COLLAR = 212,
	COLLECTIBLE_LOST_CONTACT = 213,
	COLLECTIBLE_ANEMIC = 214,
	COLLECTIBLE_GOAT_HEAD = 215,
	COLLECTIBLE_CEREMONIAL_ROBES = 216,
	COLLECTIBLE_MOMS_WIG = 217,
	COLLECTIBLE_PLACENTA = 218,
	COLLECTIBLE_OLD_BANDAGE = 219,
	COLLECTIBLE_SAD_BOMBS = 220,
	COLLECTIBLE_RUBBER_CEMENT = 221,
	COLLECTIBLE_ANTI_GRAVITY = 222,
	COLLECTIBLE_PYROMANIAC = 223,
	COLLECTIBLE_CRICKETS_BODY = 224,
	COLLECTIBLE_GIMPY = 225,
	COLLECTIBLE_BLACK_LOTUS = 226,
	COLLECTIBLE_PIGGY_BANK = 227,
	COLLECTIBLE_MOMS_PERFUME = 228,
	COLLECTIBLE_MONSTROS_LUNG = 229,
	COLLECTIBLE_ABADDON = 230,
	COLLECTIBLE_BALL_OF_TAR = 231,
	COLLECTIBLE_STOP_WATCH = 232,
	COLLECTIBLE_TINY_PLANET = 233,
	COLLECTIBLE_INFESTATION_2 = 234,
	COLLECTIBLE_235 = 235,
	COLLECTIBLE_E_COLI = 236,
	COLLECTIBLE_DEATHS_TOUCH = 237,
	COLLECTIBLE_KEY_PIECE_1 = 238,
	COLLECTIBLE_KEY_PIECE_2 = 239,
	COLLECTIBLE_EXPERIMENTAL_TREATMENT = 240,
	COLLECTIBLE_CONTRACT_FROM_BELOW = 241,
	COLLECTIBLE_INFAMY = 242,
	COLLECTIBLE_TRINITY_SHIELD = 243,
	COLLECTIBLE_TECH_5 = 244,
	COLLECTIBLE_20_20 = 245,
	COLLECTIBLE_BLUE_MAP = 246,
	COLLECTIBLE_BFFS = 247,
	COLLECTIBLE_HIVE_MIND = 248,
	COLLECTIBLE_THERES_OPTIONS = 249,
	COLLECTIBLE_BOGO_BOMBS = 250,
	COLLECTIBLE_STARTER_DECK = 251,
	COLLECTIBLE_LITTLE_BAGGY = 252,
	COLLECTIBLE_MAGIC_SCAB = 253,
	COLLECTIBLE_BLOOD_CLOT = 254,
	COLLECTIBLE_SCREW = 255,
	COLLECTIBLE_HOT_BOMBS = 256,
	COLLECTIBLE_FIRE_MIND = 257,
	COLLECTIBLE_MISSING_NO = 258,
	COLLECTIBLE_DARK_MATTER = 259,
	COLLECTIBLE_BLACK_CANDLE = 260,
	COLLECTIBLE_PROPTOSIS = 261,
	COLLECTIBLE_MISSING_PAGE_2 = 262,
	COLLECTIBLE_263 = 263,
	COLLECTIBLE_SMART_FLY = 264,
	COLLECTIBLE_DRY_BABY = 265,
	COLLECTIBLE_JUICY_SACK = 266,
	COLLECTIBLE_ROBO_BABY_2 = 267,
	COLLECTIBLE_ROTTEN_BABY = 268,
	COLLECTIBLE_HEADLESS_BABY = 269,
	COLLECTIBLE_LEECH = 270,
	COLLECTIBLE_MYSTERY_SACK = 271,
	COLLECTIBLE_BBF = 272,
	COLLECTIBLE_BOBS_BRAIN = 273,
	COLLECTIBLE_BEST_BUD = 274,
	COLLECTIBLE_LIL_BRIMSTONE = 275,
	COLLECTIBLE_ISAACS_HEART = 276,
	COLLECTIBLE_LIL_HAUNT = 277,
	COLLECTIBLE_DARK_BUM = 278,
	COLLECTIBLE_BIG_FAN = 279,
	COLLECTIBLE_SISSY_LONGLEGS = 280,
	COLLECTIBLE_PUNCHING_BAG = 281,
	COLLECTIBLE_HOW_TO_JUMP = 282,
	COLLECTIBLE_D100 = 283,
	COLLECTIBLE_D4 = 284,
	COLLECTIBLE_D10 = 285,
	COLLECTIBLE_BLANK_CARD = 286,
	COLLECTIBLE_BOOK_OF_SECRETS = 287,
	COLLECTIBLE_BOX_OF_SPIDERS = 288,
	COLLECTIBLE_RED_CANDLE = 289,
	COLLECTIBLE_THE_JAR = 290,
	COLLECTIBLE_FLUSH = 291,
	COLLECTIBLE_SATANIC_BIBLE = 292,
	COLLECTIBLE_HEAD_OF_KRAMPUS = 293,
	COLLECTIBLE_BUTTER_BEAN = 294,
	COLLECTIBLE_MAGIC_FINGERS = 295,
	COLLECTIBLE_CONVERTER = 296,
	COLLECTIBLE_BLUE_BOX = 297,
	COLLECTIBLE_UNICORN_STUMP = 298,
	COLLECTIBLE_TAURUS = 299,
	COLLECTIBLE_ARIES = 300,
	COLLECTIBLE_CANCER = 301,
	COLLECTIBLE_LEO = 302,
	COLLECTIBLE_VIRGO = 303,
	COLLECTIBLE_LIBRA = 304,
	COLLECTIBLE_SCORPIO = 305,
	COLLECTIBLE_SAGITTARIUS = 306,
	COLLECTIBLE_CAPRICORN = 307,
	COLLECTIBLE_AQUARIUS = 308,
	COLLECTIBLE_PISCES = 309,
	COLLECTIBLE_EVES_MASCARA = 310,
	COLLECTIBLE_JUDAS_SHADOW = 311,
	COLLECTIBLE_MAGGYS_BOW = 312,
	COLLECTIBLE_HOLY_MANTLE = 313,
	COLLECTIBLE_THUNDER_THIGHS = 314,
	COLLECTIBLE_STRANGE_ATTRACTOR = 315,
	COLLECTIBLE_CURSED_EYE = 316,
	COLLECTIBLE_MYSTERIOUS_LIQUID = 317,
	COLLECTIBLE_GEMINI = 318,
	COLLECTIBLE_CAINS_OTHER_EYE = 319,
	COLLECTIBLE_BLUEBABYS_ONLY_FRIEND = 320,
	COLLECTIBLE_SAMSONS_CHAINS = 321,
	COLLECTIBLE_MONGO_BABY = 322,
	COLLECTIBLE_ISAACS_TEARS = 323,
	COLLECTIBLE_UNDEFINED = 324,
	COLLECTIBLE_SCISSORS = 325,
	COLLECTIBLE_BREATH_OF_LIFE = 326,
	COLLECTIBLE_POLAROID = 327,
	COLLECTIBLE_NEGATIVE = 328,
	COLLECTIBLE_LUDOVICO_TECHNIQUE = 329,
	COLLECTIBLE_SOY_MILK = 330,
	COLLECTIBLE_GODHEAD = 331,
	COLLECTIBLE_LAZARUS_RAGS = 332,
	COLLECTIBLE_MIND = 333,
	COLLECTIBLE_BODY = 334,
	COLLECTIBLE_SOUL = 335,
	COLLECTIBLE_DEAD_ONION = 336,
	COLLECTIBLE_BROKEN_WATCH = 337,
	COLLECTIBLE_BOOMERANG = 338,
	COLLECTIBLE_SAFETY_PIN = 339,
	COLLECTIBLE_CAFFEINE_PILL = 340,
	COLLECTIBLE_TORN_PHOTO = 341,
	COLLECTIBLE_BLUE_CAP = 342,
	COLLECTIBLE_LATCH_KEY = 343,
	COLLECTIBLE_MATCH_BOOK = 344,
	COLLECTIBLE_SYNTHOIL = 345,
	COLLECTIBLE_SNACK = 346,
	COLLECTIBLE_DIPLOPIA = 347,
	COLLECTIBLE_PLACEBO = 348,
	COLLECTIBLE_WOODEN_NICKEL = 349,
	COLLECTIBLE_TOXIC_SHOCK = 350,
	COLLECTIBLE_MEGA_BEAN = 351,
	COLLECTIBLE_GLASS_CANNON = 352,
	COLLECTIBLE_BOMBER_BOY = 353,
	COLLECTIBLE_CRACK_JACKS = 354,
	COLLECTIBLE_MOMS_PEARLS = 355,
	COLLECTIBLE_CAR_BATTERY = 356,
	COLLECTIBLE_BOX_OF_FRIENDS = 357,
	COLLECTIBLE_THE_WIZ = 358,
	COLLECTIBLE_8_INCH_NAILS = 359,
	COLLECTIBLE_INCUBUS = 360,
	COLLECTIBLE_FATES_REWARD = 361,
	COLLECTIBLE_LIL_CHEST = 362,
	COLLECTIBLE_SWORN_PROTECTOR = 363,
	COLLECTIBLE_FRIEND_ZONE = 364,
	COLLECTIBLE_LOST_FLY = 365,
	COLLECTIBLE_SCATTER_BOMBS = 366,
	COLLECTIBLE_STICKY_BOMBS = 367,
	COLLECTIBLE_EPIPHORA = 368,
	COLLECTIBLE_CONTINUUM = 369,
	COLLECTIBLE_MR_DOLLY = 370,
	COLLECTIBLE_CURSE_OF_THE_TOWER = 371,
	COLLECTIBLE_CHARGED_BABY = 372,
	COLLECTIBLE_DEAD_EYE = 373,
	COLLECTIBLE_HOLY_LIGHT = 374,
	COLLECTIBLE_HOST_HAT = 375,
	COLLECTIBLE_RESTOCK = 376,
	COLLECTIBLE_BURSTING_SACK = 377,
	COLLECTIBLE_NUMBER_TWO = 378,
	COLLECTIBLE_PUPULA_DUPLEX = 379,
	COLLECTIBLE_PAY_TO_PLAY = 380,
	COLLECTIBLE_EDENS_BLESSING = 381,
	COLLECTIBLE_FRIEND_BALL = 382,
	COLLECTIBLE_TEAR_DETONATOR = 383,
	COLLECTIBLE_LIL_GURDY = 384,
	COLLECTIBLE_BUMBO = 385,
	COLLECTIBLE_D12 = 386,
	COLLECTIBLE_CENSER = 387,
	COLLECTIBLE_KEY_BUM = 388,
	COLLECTIBLE_RUNE_BAG = 389,
	COLLECTIBLE_SERAPHIM = 390,
	COLLECTIBLE_BETRAYAL = 391,
	COLLECTIBLE_ZODIAC = 392,
	COLLECTIBLE_SERPENTS_KISS = 393,
	COLLECTIBLE_MARKED = 394,
	COLLECTIBLE_TECH_X = 395,
	COLLECTIBLE_VENTRICLE_RAZOR = 396,
	COLLECTIBLE_TRACTOR_BEAM = 397,
	COLLECTIBLE_GODS_FLESH = 398,
	COLLECTIBLE_MAW_OF_VOID = 399,
	COLLECTIBLE_SPEAR_OF_DESTINY = 400,
	COLLECTIBLE_EXPLOSIVO = 401,
	COLLECTIBLE_CHAOS = 402,
	COLLECTIBLE_SPIDER_MOD = 403,
	COLLECTIBLE_FARTING_BABY = 404,
	COLLECTIBLE_GB_BUG = 405,
	COLLECTIBLE_D8 = 406,
	COLLECTIBLE_PURITY = 407,
	COLLECTIBLE_ATHAME = 408,
	COLLECTIBLE_EMPTY_VESSEL = 409,
	COLLECTIBLE_EVIL_EYE = 410,
	COLLECTIBLE_LUSTY_BLOOD = 411,
	COLLECTIBLE_CAMBION_CONCEPTION = 412,
	COLLECTIBLE_IMMACULATE_CONCEPTION = 413,
	COLLECTIBLE_MORE_OPTIONS = 414,
	COLLECTIBLE_CROWN_OF_LIGHT = 415,
	COLLECTIBLE_DEEP_POCKETS = 416,
	COLLECTIBLE_SUCCUBUS = 417,
	COLLECTIBLE_FRUIT_CAKE = 418,
	COLLECTIBLE_TELEPORT_2 = 419,
	COLLECTIBLE_BLACK_POWDER = 420,
	COLLECTIBLE_KIDNEY_BEAN = 421,
	COLLECTIBLE_GLOWING_HOUR_GLASS = 422,
	COLLECTIBLE_CIRCLE_OF_PROTECTION = 423,
	COLLECTIBLE_SACK_HEAD = 424,
	COLLECTIBLE_NIGHT_LIGHT = 425,
	COLLECTIBLE_OBSESSED_FAN = 426,
	COLLECTIBLE_MINE_CRAFTER = 427,
	COLLECTIBLE_PJS = 428,
	COLLECTIBLE_HEAD_OF_THE_KEEPER = 429,
	COLLECTIBLE_PAPA_FLY = 430,
	COLLECTIBLE_MULTIDIMENSIONAL_BABY = 431,
	COLLECTIBLE_GLITTER_BOMBS = 432,
	COLLECTIBLE_MY_SHADOW = 433,
	COLLECTIBLE_JAR_OF_FLIES = 434,
	COLLECTIBLE_LIL_LOKI = 435,
	COLLECTIBLE_MILK = 436,
	COLLECTIBLE_D7 = 437,
	COLLECTIBLE_BINKY = 438,
	COLLECTIBLE_MOMS_BOX = 439,
	COLLECTIBLE_KIDNEY_STONE = 440,
	COLLECTIBLE_MEGA_SATANS_BREATH = 441,
	COLLECTIBLE_DARK_PRINCESS_CROWN = 442,
	COLLECTIBLE_APPLE = 443,
	COLLECTIBLE_LEAD_PENCIL = 444,
	COLLECTIBLE_DOG_TOOTH = 445,
	COLLECTIBLE_DEAD_TOOTH = 446,
	COLLECTIBLE_LINGER_BEAN = 447,
	COLLECTIBLE_SHARD_OF_GLASS = 448,
	COLLECTIBLE_METAL_PLATE = 449,
	COLLECTIBLE_EYE_OF_GREED = 450,
	COLLECTIBLE_TAROT_CLOTH = 451,
	COLLECTIBLE_VARICOSE_VEINS = 452,
	COLLECTIBLE_COMPOUND_FRACTURE = 453,
	COLLECTIBLE_POLYDACTYLY = 454,
	COLLECTIBLE_DADS_LOST_COIN = 455,
	COLLECTIBLE_MOLDY_BREAD = 456,
	COLLECTIBLE_CONE_HEAD = 457,
	COLLECTIBLE_BELLY_BUTTON = 458,
	COLLECTIBLE_SINUS_INFECTION = 459,
	COLLECTIBLE_GLAUCOMA = 460,
	COLLECTIBLE_PARASITOID = 461,
	COLLECTIBLE_EYE_OF_BELIAL = 462,
	COLLECTIBLE_SULFURIC_ACID = 463,
	COLLECTIBLE_GLYPH_OF_BALANCE = 464,
	COLLECTIBLE_ANALOG_STICK = 465,
	COLLECTIBLE_CONTAGION = 466,
	COLLECTIBLE_FINGER = 467,
	COLLECTIBLE_SHADE = 468,
	COLLECTIBLE_DEPRESSION = 469,
	COLLECTIBLE_HUSHY = 470,
	COLLECTIBLE_LIL_MONSTRO = 471,
	COLLECTIBLE_KING_BABY = 472,
	COLLECTIBLE_BIG_CHUBBY = 473,
	COLLECTIBLE_TONSIL = 474,
	COLLECTIBLE_PLAN_C = 475,
	COLLECTIBLE_D1 = 476,
	COLLECTIBLE_VOID = 477,
	COLLECTIBLE_PAUSE = 478,
	COLLECTIBLE_SMELTER = 479,
	COLLECTIBLE_COMPOST = 480,
	COLLECTIBLE_DATAMINER = 481,
	COLLECTIBLE_CLICKER = 482,
	COLLECTIBLE_MAMA_MEGA = 483,
	COLLECTIBLE_WAIT_WHAT = 484,
	COLLECTIBLE_CROOKED_PENNY = 485,
	COLLECTIBLE_DULL_RAZOR = 486,
	COLLECTIBLE_POTATO_PEELER = 487,
	COLLECTIBLE_METRONOME = 488,
	COLLECTIBLE_DINF = 489,
	COLLECTIBLE_EDENS_SOUL = 490,
	COLLECTIBLE_ACID_BABY = 491,
	COLLECTIBLE_YO_LISTEN = 492,
	COLLECTIBLE_ADDERLINE = 493,
	COLLECTIBLE_JACOBS_LADDER = 494,
	COLLECTIBLE_GHOST_PEPPER = 495,
	COLLECTIBLE_EUTHANASIA = 496,
	COLLECTIBLE_CAMO_UNDIES = 497,
	COLLECTIBLE_DUALITY = 498,
	COLLECTIBLE_EUCHARIST = 499,
	COLLECTIBLE_SACK_OF_SACKS = 500,
	COLLECTIBLE_GREEDS_GULLET = 501,
	COLLECTIBLE_LARGE_ZIT = 502,
	COLLECTIBLE_LITTLE_HORN = 503,
	COLLECTIBLE_BROWN_NUGGET = 504,
	COLLECTIBLE_POKE_GO = 505,
	COLLECTIBLE_BACKSTABBER = 506,
	COLLECTIBLE_SHARP_STRAW = 507,
	COLLECTIBLE_MOMS_RAZOR = 508,
	COLLECTIBLE_BLOODSHOT_EYE = 509,
	COLLECTIBLE_DELIRIOUS = 510,
	NUM_COLLECTIBLES = 511
}
TrinketType = {
	TRINKET_NULL = 0,
	TRINKET_SWALLOWED_PENNY = 1,
	TRINKET_PETRIFIED_POOP = 2,
	TRINKET_AAA_BATTERY = 3,
	TRINKET_BROKEN_REMOTE = 4,
	TRINKET_PURPLE_HEART = 5,
	TRINKET_BROKEN_MAGNET = 6,
	TRINKET_ROSARY_BEAD = 7,
	TRINKET_CARTRIDGE = 8,
	TRINKET_PULSE_WORM = 9,
	TRINKET_WIGGLE_WORM = 10,
	TRINKET_RING_WORM = 11,
	TRINKET_FLAT_WORM = 12,
	TRINKET_STORE_CREDIT = 13,
	TRINKET_CALLUS = 14,
	TRINKET_LUCKY_ROCK = 15,
	TRINKET_MOMS_TOENAIL = 16,
	TRINKET_BLACK_LIPSTICK = 17,
	TRINKET_BIBLE_TRACT = 18,
	TRINKET_PAPER_CLIP = 19,
	TRINKET_MONKEY_PAW = 20,
	TRINKET_MYSTERIOUS_PAPER = 21,
	TRINKET_DAEMONS_TAIL = 22,
	TRINKET_MISSING_POSTER = 23,
	TRINKET_BUTT_PENNY = 24,
	TRINKET_MYSTERIOUS_CANDY = 25,
	TRINKET_HOOK_WORM = 26,
	TRINKET_WHIP_WORM = 27,
	TRINKET_BROKEN_ANKH = 28,
	TRINKET_FISH_HEAD = 29,
	TRINKET_PINKY_EYE = 30,
	TRINKET_PUSH_PIN = 31,
	TRINKET_LIBERTY_CAP = 32,
	TRINKET_UMBILICAL_CORD = 33,
	TRINKET_CHILDS_HEART = 34,
	TRINKET_CURVED_HORN = 35,
	TRINKET_RUSTED_KEY = 36,
	TRINKET_GOAT_HOOF = 37,
	TRINKET_MOMS_PEARL = 38,
	TRINKET_CANCER = 39,
	TRINKET_RED_PATCH = 40,
	TRINKET_MATCH_STICK = 41,
	TRINKET_LUCKY_TOE = 42,
	TRINKET_CURSED_SKULL = 43,
	TRINKET_SAFETY_CAP = 44,
	TRINKET_ACE_SPADES = 45,
	TRINKET_ISAACS_FORK = 46,
	TRINKET_POLAROID_OBSOLETE = 47,
	TRINKET_MISSING_PAGE = 48,
	TRINKET_BLOODY_PENNY = 49,
	TRINKET_BURNT_PENNY = 50,
	TRINKET_FLAT_PENNY = 51,
	TRINKET_COUNTERFEIT_PENNY = 52,
	TRINKET_TICK = 53,
	TRINKET_ISAACS_HEAD = 54,
	TRINKET_MAGGYS_FAITH = 55,
	TRINKET_JUDAS_TONGUE = 56,
	TRINKET_SOUL = 57,
	TRINKET_SAMSONS_LOCK = 58,
	TRINKET_CAINS_EYE = 59,
	TRINKET_EVES_BIRD_FOOT = 60,
	TRINKET_LEFT_HAND = 61,
	TRINKET_SHINY_ROCK = 62,
	TRINKET_SAFETY_SCISSORS = 63,
	TRINKET_RAINBOW_WORM = 64,
	TRINKET_TAPE_WORM = 65,
	TRINKET_LAZY_WORM = 66,
	TRINKET_CRACKED_DICE = 67,
	TRINKET_SUPER_MAGNET = 68,
	TRINKET_FADED_POLAROID = 69,
	TRINKET_LOUSE = 70,
	TRINKET_BOBS_BLADDER = 71,
	TRINKET_WATCH_BATTERY = 72,
	TRINKET_BLASTING_CAP = 73,
	TRINKET_STUD_FINDER = 74,
	TRINKET_ERROR = 75,
	TRINKET_POKER_CHIP = 76,
	TRINKET_BLISTER = 77,
	TRINKET_SECOND_HAND = 78,
	TRINKET_ENDLESS_NAMELESS = 79,
	TRINKET_BLACK_FEATHER = 80,
	TRINKET_BLIND_RAGE = 81,
	TRINKET_GOLDEN_HORSE_SHOE = 82,
	TRINKET_STORE_KEY = 83,
	TRINKET_RIB_OF_GREED = 84,
	TRINKET_KARMA = 85,
	TRINKET_LIL_LARVA = 86,
	TRINKET_MOMS_LOCKET = 87,
	TRINKET_NO = 88,
	TRINKET_CHILD_LEASH = 89,
	TRINKET_BROWN_CAP = 90,
	TRINKET_MECONIUM = 91,
	TRINKET_CRACKED_CROWN = 92,
	TRINKET_USED_DIAPER = 93,
	TRINKET_FISH_TAIL = 94,
	TRINKET_BLACK_TOOTH = 95,
	TRINKET_OUROBOROS_WORM = 96,
	TRINKET_TONSIL = 97,
	TRINKET_NOSE_GOBLIN = 98,
	TRINKET_SUPER_BALL = 99,
	TRINKET_VIBRANT_BULB = 100,
	TRINKET_DIM_BULB = 101,
	TRINKET_FRAGMENTED_CARD = 102,
	TRINKET_EQUALITY = 103,
	TRINKET_WISH_BONE = 104,
	TRINKET_BAG_LUNCH = 105,
	TRINKET_LOST_CORK = 106,
	TRINKET_CROW_HEART = 107,
	TRINKET_WALNUT = 108,
	TRINKET_DUCT_TAPE = 109,
	TRINKET_SILVER_DOLLAR = 110,
	TRINKET_BLOODY_CROWN = 111,
	TRINKET_PAY_TO_WIN = 112,
	TRINKET_LOCUST_OF_WRATH = 113,
	TRINKET_LOCUST_OF_PESTILENCE = 114,
	TRINKET_LOCUST_OF_FAMINE = 115,
	TRINKET_LOCUST_OF_DEATH = 116,
	TRINKET_LOCUST_OF_CONQUEST = 117,
	TRINKET_BAT_WING = 118,
	TRINKET_STEM_CELL = 119,
	NUM_TRINKETS = 120
}
PillEffect = {
	PILLEFFECT_NULL = - 1,
	PILLEFFECT_BAD_GAS = 0,
	PILLEFFECT_BAD_TRIP = 1,
	PILLEFFECT_BALLS_OF_STEEL = 2,
	PILLEFFECT_BOMBS_ARE_KEYS = 3,
	PILLEFFECT_EXPLOSIVE_DIARRHEA = 4,
	PILLEFFECT_FULL_HEALTH = 5,
	PILLEFFECT_HEALTH_DOWN = 6,
	PILLEFFECT_HEALTH_UP = 7,
	PILLEFFECT_I_FOUND_PILLS = 8,
	PILLEFFECT_PUBERTY = 9,
	PILLEFFECT_PRETTY_FLY = 10,
	PILLEFFECT_RANGE_DOWN = 11,
	PILLEFFECT_RANGE_UP = 12,
	PILLEFFECT_SPEED_DOWN = 13,
	PILLEFFECT_SPEED_UP = 14,
	PILLEFFECT_TEARS_DOWN = 15,
	PILLEFFECT_TEARS_UP = 16,
	PILLEFFECT_LUCK_DOWN = 17,
	PILLEFFECT_LUCK_UP = 18,
	PILLEFFECT_TELEPILLS = 19,
	PILLEFFECT_48HOUR_ENERGY = 20,
	PILLEFFECT_HEMATEMESIS = 21,
	PILLEFFECT_PARALYSIS = 22,
	PILLEFFECT_SEE_FOREVER = 23,
	PILLEFFECT_PHEROMONES = 24,
	PILLEFFECT_AMNESIA = 25,
	PILLEFFECT_LEMON_PARTY = 26,
	PILLEFFECT_WIZARD = 27,
	PILLEFFECT_PERCS = 28,
	PILLEFFECT_ADDICTED = 29,
	PILLEFFECT_RELAX = 30,
	PILLEFFECT_QUESTIONMARK = 31,
	PILLEFFECT_LARGER = 32,
	PILLEFFECT_SMALLER = 33,
	PILLEFFECT_INFESTED_EXCLAMATION = 34,
	PILLEFFECT_INFESTED_QUESTION = 35,
	PILLEFFECT_POWER = 36,
	PILLEFFECT_RETRO_VISION = 37,
	PILLEFFECT_FRIENDS_TILL_THE_END = 38,
	PILLEFFECT_X_LAX = 39,
	PILLEFFECT_SOMETHINGS_WRONG = 40,
	PILLEFFECT_IM_DROWSY = 41,
	PILLEFFECT_IM_EXCITED = 42,
	PILLEFFECT_GULP = 43,
	PILLEFFECT_HORF = 44,
	PILLEFFECT_SUNSHINE = 45,
	PILLEFFECT_VURP = 46,
	NUM_PILL_EFFECTS = 47
}
Card = {
	CARD_RANDOM = - 1,
	CARD_NULL = 0,
	CARD_FOOL = 1,
	CARD_MAGICIAN = 2,
	CARD_HIGH_PRIESTESS = 3,
	CARD_EMPRESS = 4,
	CARD_EMPEROR = 5,
	CARD_HIEROPHANT = 6,
	CARD_LOVERS = 7,
	CARD_CHARIOT = 8,
	CARD_JUSTICE = 9,
	CARD_HERMIT = 10,
	CARD_WHEEL_OF_FORTUNE = 11,
	CARD_STRENGTH = 12,
	CARD_HANGED_MAN = 13,
	CARD_DEATH = 14,
	CARD_TEMPERANCE = 15,
	CARD_DEVIL = 16,
	CARD_TOWER = 17,
	CARD_STARS = 18,
	CARD_MOON = 19,
	CARD_SUN = 20,
	CARD_JUDGEMENT = 21,
	CARD_WORLD = 22,
	CARD_CLUBS_2 = 23,
	CARD_DIAMONDS_2 = 24,
	CARD_SPADES_2 = 25,
	CARD_HEARTS_2 = 26,
	CARD_ACE_OF_CLUBS = 27,
	CARD_ACE_OF_DIAMONDS = 28,
	CARD_ACE_OF_SPADES = 29,
	CARD_ACE_OF_HEARTS = 30,
	CARD_JOKER = 31,
	RUNE_HAGALAZ = 32,
	RUNE_JERA = 33,
	RUNE_EHWAZ = 34,
	RUNE_DAGAZ = 35,
	RUNE_ANSUZ = 36,
	RUNE_PERTHRO = 37,
	RUNE_BERKANO = 38,
	RUNE_ALGIZ = 39,
	RUNE_BLANK = 40,
	RUNE_BLACK = 41,
	CARD_CHAOS = 42,
	CARD_CREDIT = 43,
	CARD_RULES = 44,
	CARD_HUMANITY = 45,
	CARD_SUICIDE_KING = 46,
	CARD_GET_OUT_OF_JAIL = 47,
	CARD_QUESTIONMARK = 48,
	CARD_DICE_SHARD = 49,
	CARD_EMERGENCY_CONTACT = 50,
	CARD_HOLY = 51,
	NUM_CARDS = 52
}